/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.conveter;

import io.github.biezhi.excel.plus.annotation.ExcelColumn;
import io.github.biezhi.excel.plus.conveter.BigIntConverter;
import io.github.biezhi.excel.plus.conveter.BooleanConverter;
import io.github.biezhi.excel.plus.conveter.ByteConverter;
import io.github.biezhi.excel.plus.conveter.Converter;
import io.github.biezhi.excel.plus.conveter.DateConverter;
import io.github.biezhi.excel.plus.conveter.DecimalConverter;
import io.github.biezhi.excel.plus.conveter.DoubleConverter;
import io.github.biezhi.excel.plus.conveter.FloatConverter;
import io.github.biezhi.excel.plus.conveter.IntConverter;
import io.github.biezhi.excel.plus.conveter.LocalDateConverter;
import io.github.biezhi.excel.plus.conveter.LocalDateTimeConverter;
import io.github.biezhi.excel.plus.conveter.LongConverter;
import io.github.biezhi.excel.plus.conveter.NullConverter;
import io.github.biezhi.excel.plus.conveter.ShortConverter;
import io.github.biezhi.excel.plus.conveter.StringConverter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class ConverterCache {
    private static final Map<Class<? extends Converter>, Converter> CONVERTER_MAP = new HashMap<Class<? extends Converter>, Converter>(64);

    public static void addConvert(Converter converter) {
        if (null != converter) {
            CONVERTER_MAP.put(converter.getClass(), converter);
        }
    }

    public static Converter getConvert(Class<? extends Converter> type) {
        return CONVERTER_MAP.get(type);
    }

    public static Converter computeConvert(Field field) throws Exception {
        if (null == field) {
            return null;
        }
        Class<?> fieldType = field.getType();
        ExcelColumn column = field.getAnnotation(ExcelColumn.class);
        if (null != column && !NullConverter.class.equals(column.converter())) {
            return column.converter().newInstance();
        }
        if (fieldType.equals(String.class)) {
            return ConverterCache.getConvert(StringConverter.class);
        }
        if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
            return ConverterCache.getConvert(IntConverter.class);
        }
        if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
            return ConverterCache.getConvert(LongConverter.class);
        }
        if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
            return ConverterCache.getConvert(DoubleConverter.class);
        }
        if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class)) {
            return ConverterCache.getConvert(FloatConverter.class);
        }
        if (fieldType.equals(Short.TYPE) || fieldType.equals(Short.class)) {
            return ConverterCache.getConvert(ShortConverter.class);
        }
        if (fieldType.equals(Byte.TYPE) || fieldType.equals(Byte.class)) {
            return ConverterCache.getConvert(ByteConverter.class);
        }
        if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
            return ConverterCache.getConvert(BooleanConverter.class);
        }
        if (fieldType.equals(BigInteger.class)) {
            return ConverterCache.getConvert(BigIntConverter.class);
        }
        if (fieldType.equals(BigDecimal.class)) {
            return ConverterCache.getConvert(DecimalConverter.class);
        }
        if (fieldType.equals(Date.class)) {
            String pattern = field.getAnnotation(ExcelColumn.class).datePattern();
            return new DateConverter(pattern);
        }
        if (fieldType.equals(LocalDate.class)) {
            String pattern = field.getAnnotation(ExcelColumn.class).datePattern();
            return new LocalDateConverter(pattern);
        }
        if (fieldType.equals(LocalDateTime.class)) {
            String pattern = field.getAnnotation(ExcelColumn.class).datePattern();
            return new LocalDateTimeConverter(pattern);
        }
        return null;
    }

    private ConverterCache() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        CONVERTER_MAP.put(StringConverter.class, new StringConverter());
        CONVERTER_MAP.put(IntConverter.class, new IntConverter());
        CONVERTER_MAP.put(LongConverter.class, new LongConverter());
        CONVERTER_MAP.put(ShortConverter.class, new ShortConverter());
        CONVERTER_MAP.put(ByteConverter.class, new ByteConverter());
        CONVERTER_MAP.put(BooleanConverter.class, new BooleanConverter());
        CONVERTER_MAP.put(DoubleConverter.class, new DoubleConverter());
        CONVERTER_MAP.put(FloatConverter.class, new FloatConverter());
        CONVERTER_MAP.put(DecimalConverter.class, new DecimalConverter());
        CONVERTER_MAP.put(BigIntConverter.class, new BigIntConverter());
    }
}

