/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus;

import io.github.biezhi.excel.plus.enums.ExcelType;
import io.github.biezhi.excel.plus.exception.WriterException;
import io.github.biezhi.excel.plus.types.StyleConsumer;
import io.github.biezhi.excel.plus.util.StringUtil;
import io.github.biezhi.excel.plus.writer.WriterWith2003;
import io.github.biezhi.excel.plus.writer.WriterWith2007;
import io.github.biezhi.excel.plus.writer.WriterWithCSV;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class Writer {
    private String sheetName = "Sheet0";
    private Collection<?> rows;
    private int startRow;
    private int bufferSize = 100;
    private boolean withRaw;
    private ExcelType excelType;
    private String headerTitle;
    private File template;
    private StyleConsumer<Workbook, CellStyle> titleStyle;
    private StyleConsumer<Workbook, CellStyle> headerStyle;
    private StyleConsumer<Workbook, CellStyle> cellStyle;
    private Consumer<Sheet> sheetConsumer;
    private Charset charset = StandardCharsets.UTF_8;

    public static Writer create() {
        return new Writer(ExcelType.XLSX);
    }

    public static Writer create(ExcelType excelType) {
        return new Writer(excelType);
    }

    public Writer(ExcelType excelType) {
        this.excelType = excelType;
    }

    public Writer withRows(Collection<?> rows) {
        this.rows = rows;
        return this;
    }

    public Writer sheet(String sheetName) {
        if (StringUtil.isEmpty(sheetName)) {
            throw new IllegalArgumentException("sheet cannot be empty");
        }
        this.sheetName = sheetName;
        return this;
    }

    public Writer start(int startRow) {
        if (startRow < 0) {
            throw new IllegalArgumentException("start cannot be less than 0");
        }
        this.startRow = startRow;
        return this;
    }

    public Writer headerTitle(String title) {
        this.headerTitle = title;
        return this;
    }

    public Writer titleStyle(StyleConsumer<Workbook, CellStyle> titleStyle) {
        this.titleStyle = titleStyle;
        return this;
    }

    public Writer headerStyle(StyleConsumer<Workbook, CellStyle> headerStyle) {
        this.headerStyle = headerStyle;
        return this;
    }

    public Writer cellStyle(StyleConsumer<Workbook, CellStyle> cellStyle) {
        this.cellStyle = cellStyle;
        return this;
    }

    public Writer withTemplate(String templatePath) {
        return this.withTemplate(new File(templatePath));
    }

    public Writer withTemplate(File template) {
        if (null == template || !template.exists()) {
            throw new IllegalArgumentException("template file not exist");
        }
        this.template = template;
        return this;
    }

    public Writer bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public Writer createRow(Consumer<Sheet> sheetConsumer) {
        this.sheetConsumer = sheetConsumer;
        return this;
    }

    public Writer withRaw() {
        this.withRaw = true;
        return this;
    }

    public Writer charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public void to(File file) throws WriterException {
        try {
            this.to(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new WriterException(e);
        }
    }

    public void to(OutputStream outputStream) throws WriterException {
        if (!this.withRaw && (null == this.rows || this.rows.isEmpty())) {
            throw new WriterException("write rows cannot be empty, please check it");
        }
        if (this.excelType == ExcelType.XLSX) {
            new WriterWith2007(outputStream).writeSheet(this);
        }
        if (this.excelType == ExcelType.XLS) {
            new WriterWith2003(outputStream).writeSheet(this);
        }
        if (this.excelType == ExcelType.CSV) {
            new WriterWithCSV(outputStream).writeSheet(this);
        }
    }

    public int startRow() {
        return this.startRow;
    }

    public String sheetName() {
        return this.sheetName;
    }

    public StyleConsumer<Workbook, CellStyle> titleStyle() {
        return this.titleStyle;
    }

    public StyleConsumer<Workbook, CellStyle> headerStyle() {
        return this.headerStyle;
    }

    public StyleConsumer<Workbook, CellStyle> cellStyle() {
        return this.cellStyle;
    }

    public File template() {
        return this.template;
    }

    public String headerTitle() {
        return this.headerTitle;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public Collection<?> rows() {
        return this.rows;
    }

    public Consumer<Sheet> sheetConsumer() {
        return this.sheetConsumer;
    }

    public boolean isRaw() {
        return this.withRaw;
    }

    public Charset charset() {
        return this.charset;
    }
}

