/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.timer.scheduled;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.timing.timer.AbstractTimer;
import com.jn.langx.util.timing.timer.RunnableToTimerTaskAdapter;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.TimerTask;
import com.jn.langx.util.timing.timer.scheduled.ScheduledTimeout;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorTimer
extends AbstractTimer {
    private ScheduledExecutorService scheduledExecutor;

    public ScheduledExecutorTimer(ScheduledExecutorService scheduledExecutor, Executor taskExecutor) {
        this.scheduledExecutor = scheduledExecutor;
        this.setTaskExecutor(taskExecutor);
        this.running = true;
    }

    @Override
    public Timeout newTimeout(Runnable task, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(task, "task is required");
        RunnableToTimerTaskAdapter tt = new RunnableToTimerTaskAdapter(task);
        return this.newTimeout(tt, delay, unit);
    }

    @Override
    public Timeout newTimeout(@NonNull TimerTask task, long delay, @NonNull TimeUnit unit) {
        if (task == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay < 0L) {
            delay = 0L;
        }
        long deadlineInMills = System.currentTimeMillis() + unit.toMillis(delay);
        final ScheduledTimeout timeout = new ScheduledTimeout(this, task, deadlineInMills);
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                timeout.executeTask();
            }
        }, delay, unit);
        timeout.setFuture(scheduledFuture);
        return timeout;
    }

    @Override
    public Set<Timeout> stop() {
        this.running = false;
        this.scheduledExecutor.shutdown();
        return null;
    }
}

