/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.struct.counter;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.struct.counter.IntegerCounter;
import java.util.concurrent.atomic.AtomicInteger;

public class AtomicIntegerCounter
extends IntegerCounter {
    private AtomicInteger vh;

    public AtomicIntegerCounter() {
        this(0);
    }

    public AtomicIntegerCounter(int init) {
        this.vh = new AtomicInteger(init);
    }

    @Override
    public Integer increment(Integer delta) {
        Preconditions.checkNotNull(delta);
        return this.vh.addAndGet(delta);
    }

    @Override
    public Integer getAndIncrement(Integer delta) {
        Preconditions.checkNotNull(delta);
        return this.vh.getAndAdd(delta);
    }

    @Override
    public Integer get() {
        return this.vh.get();
    }

    @Override
    public void set(Integer value) {
        Preconditions.checkNotNull(value);
        this.vh.set(value);
    }
}

