/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.regexp.named;

import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.Regexps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Groups {
    public static final int INDEX_GROUP_NAME = 1;
    private static final String NAME_PATTERN = "[^!=].*?";
    public static final Pattern NAMED_GROUP_PATTERN = Pattern.compile("\\(\\?<([^!=].*?)>", 32);
    public static final Pattern BACKREF_NAMED_GROUP_PATTERN = Pattern.compile("\\\\k<([^!=].*?)>", 32);
    public static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{([^!=].*?)\\}", 32);

    Groups() {
    }

    public static int indexOf(Map<String, List<GroupCoordinate>> groupInfo, String groupName) {
        return Groups.indexOf(groupInfo, groupName, 0);
    }

    public static int indexOf(Map<String, List<GroupCoordinate>> groupInfo, String groupName, int index) {
        int idx = -1;
        if (groupInfo.containsKey(groupName)) {
            List<GroupCoordinate> list = groupInfo.get(groupName);
            idx = list.get(index).groupIndex();
        }
        return idx;
    }

    public static int groupIndex(Map<String, List<GroupCoordinate>> groupInfo, String groupName) {
        int idx = Groups.indexOf(groupInfo, groupName);
        return idx > -1 ? idx + 1 : -1;
    }

    public static Map<String, List<GroupCoordinate>> extractGroupInfo(String namedPattern) {
        LinkedHashMap<String, List<GroupCoordinate>> groupInfo = new LinkedHashMap<String, List<GroupCoordinate>>();
        Matcher matcher = NAMED_GROUP_PATTERN.matcher(namedPattern);
        while (matcher.find()) {
            int pos = matcher.start();
            if (Groups.isEscapedChar(namedPattern, pos)) continue;
            String name = matcher.group(1);
            int groupIndex = Groups.countOpenParens(namedPattern, pos);
            List list = groupInfo.containsKey(name) ? (List)groupInfo.get(name) : new ArrayList();
            list.add(new GroupCoordinate(groupIndex, pos));
            groupInfo.put(name, list);
        }
        return groupInfo;
    }

    public static boolean isEscapedChar(String s, int pos) {
        return Groups.isSlashEscapedChar(s, pos) || Groups.isQuoteEscapedChar(s, pos);
    }

    public static boolean isSlashEscapedChar(String s, int pos) {
        int numSlashes = 0;
        while (pos > 0 && s.charAt(pos - 1) == '\\') {
            --pos;
            ++numSlashes;
        }
        return numSlashes % 2 != 0;
    }

    public static boolean isQuoteEscapedChar(String s, int pos) {
        boolean openQuoteFound = false;
        boolean closeQuoteFound = false;
        String s2 = s.substring(0, pos);
        int posOpen = pos;
        while ((posOpen = s2.lastIndexOf("\\Q", posOpen - 1)) != -1) {
            if (Groups.isSlashEscapedChar(s2, posOpen)) continue;
            openQuoteFound = true;
            break;
        }
        if (openQuoteFound && s2.indexOf("\\E", posOpen) != -1) {
            closeQuoteFound = true;
        }
        return openQuoteFound && !closeQuoteFound;
    }

    public static boolean isInsideCharClass(String s, int pos) {
        boolean openBracketFound = false;
        boolean closeBracketFound = false;
        String s2 = s.substring(0, pos);
        int posOpen = pos;
        while ((posOpen = s2.lastIndexOf(91, posOpen - 1)) != -1) {
            if (Groups.isEscapedChar(s2, posOpen)) continue;
            openBracketFound = true;
            break;
        }
        if (openBracketFound) {
            String s3 = s.substring(posOpen, pos);
            int posClose = -1;
            while ((posClose = s3.indexOf(93, posClose + 1)) != -1) {
                if (Groups.isEscapedChar(s3, posClose)) continue;
                closeBracketFound = true;
                break;
            }
        }
        return openBracketFound && !closeBracketFound;
    }

    private static boolean isNoncapturingParen(String s, int pos) {
        boolean isLookbehind = false;
        String pre = s.substring(pos, pos + 4);
        isLookbehind = pre.equals("(?<=") || pre.equals("(?<!");
        return s.charAt(pos + 1) == '?' && (isLookbehind || s.charAt(pos + 2) != '<');
    }

    private static int countOpenParens(String s, int pos) {
        Regexp p = Regexps.compile("\\(");
        RegexpMatcher m = p.matcher(s.subSequence(0, pos));
        int numParens = 0;
        while (m.find()) {
            if (Groups.isInsideCharClass(s, m.start()) || Groups.isEscapedChar(s, m.start()) || Groups.isNoncapturingParen(s, m.start())) continue;
            ++numParens;
        }
        return numParens;
    }

    public static class GroupCoordinate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int pos;
        private int groupIndex;

        public GroupCoordinate(int groupIndex, int pos) {
            this.groupIndex = groupIndex;
            this.pos = pos;
        }

        public int pos() {
            return this.pos;
        }

        public int groupIndex() {
            return this.groupIndex;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof GroupCoordinate)) {
                return false;
            }
            GroupCoordinate other = (GroupCoordinate)obj;
            return this.pos == other.pos && this.groupIndex == other.groupIndex;
        }

        public int hashCode() {
            return this.pos ^ this.groupIndex;
        }
    }
}

