/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect.reference;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.reflect.reference.ReferenceType;
import com.jn.langx.util.reflect.reference.References;
import com.jn.langx.util.struct.Reference;
import java.lang.ref.ReferenceQueue;

public class ReferenceEntry<K, V> {
    protected Object keyRef;
    private ReferenceType keyReferenceType = ReferenceType.STRONG;
    protected Object valueRef;
    private ReferenceType valueReferenceType = ReferenceType.STRONG;
    private ReferenceQueue refQueue;
    private boolean wrappedWhenStrong = false;

    public ReferenceEntry(K key, ReferenceType keyReferenceType, V value, ReferenceType valueReferenceType, ReferenceQueue referenceQueue, boolean wrappedWhenStrong) {
        this.setKeyReferenceType(keyReferenceType);
        this.setValueReferenceType(valueReferenceType);
        this.setKey(key);
        this.setValue(value);
        this.refQueue = referenceQueue;
        this.wrappedWhenStrong = wrappedWhenStrong;
    }

    public ReferenceEntry(K key, V value, ReferenceQueue referenceQueue, boolean wrappedWhenStrong) {
        this(key, ReferenceType.STRONG, value, ReferenceType.STRONG, referenceQueue, wrappedWhenStrong);
    }

    public K getKey() {
        if (this.keyReferenceType == ReferenceType.STRONG) {
            return (K)this.keyRef;
        }
        if (this.keyRef instanceof Reference) {
            return (K)((Reference)this.keyRef).get();
        }
        return (K)this.keyRef;
    }

    public void setKey(K key) {
        Preconditions.checkNotNull(key);
        this.keyRef = References.newReference(key, this.keyReferenceType, this.refQueue, this.wrappedWhenStrong);
    }

    public V getValue() {
        if (this.valueReferenceType == ReferenceType.STRONG) {
            return (V)this.valueRef;
        }
        if (this.valueRef instanceof Reference) {
            return (V)((Reference)this.valueRef).get();
        }
        return (V)this.valueRef;
    }

    public void setValue(V value) {
        Preconditions.checkNotNull(value);
        this.valueRef = References.newReference(value, this.valueReferenceType, this.refQueue, this.wrappedWhenStrong);
    }

    private void setKeyReferenceType(ReferenceType keyReferenceType) {
        this.keyReferenceType = keyReferenceType;
    }

    private void setValueReferenceType(ReferenceType valueReferenceType) {
        this.valueReferenceType = valueReferenceType;
    }
}

