/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.reflect;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.BasedStringAccessor;
import com.jn.langx.util.reflect.Reflects;

public class FieldAccessor
extends BasedStringAccessor<String, Object> {
    public FieldAccessor() {
    }

    public FieldAccessor(@NonNull Object target) {
        this.setTarget(target);
    }

    private <V> V getFieldValue(String fieldName, V defaultValue) {
        Object v = Reflects.getAnyFieldValue(this.getTarget(), fieldName, true, true);
        if (v == null) {
            v = defaultValue;
        }
        return v;
    }

    private <V> void setFieldValue(String fieldName, V value) {
        Reflects.setAnyFieldValue(this.getTarget(), fieldName, value, true, false);
    }

    @Override
    public Object get(String field) {
        return this.getFieldValue(field, null);
    }

    @Override
    public boolean has(String key) {
        return Reflects.getAnyField(this.getTarget().getClass(), key) != null;
    }

    @Override
    public String getString(String key, String defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    @Override
    public void set(String field, Object value) {
        this.setFieldValue(field, value);
    }

    @Override
    public void setString(String field, String value) {
        this.set(field, (Object)value);
    }

    @Override
    public void remove(String field) {
        this.set(field, (Object)null);
    }
}

