/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net.http;

import com.jn.langx.util.Strings;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.net.Nets;
import com.jn.langx.util.net.http.HttpUrlEncodes;
import com.jn.langx.util.struct.pair.StringNameValuePair;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class HttpUrlBuilder {
    private String scheme;
    private String encodedSchemeSpecificPart;
    private String encodedAuthority;
    private String userInfo;
    private String encodedUserInfo;
    private String host;
    private int port;
    private String encodedPath;
    private List<String> pathSegments;
    private String encodedQuery;
    private List<StringNameValuePair> queryParams;
    private String query;
    private Charset charset;
    private String fragment;
    private String encodedFragment;

    public HttpUrlBuilder() {
        this.port = -1;
    }

    public HttpUrlBuilder(String url) throws URISyntaxException {
        this(new URI(url), null);
    }

    public HttpUrlBuilder(URI uri) {
        this(uri, null);
    }

    public HttpUrlBuilder(String url, Charset charset) throws URISyntaxException {
        this(new URI(url), charset);
    }

    public HttpUrlBuilder(URI uri, Charset charset) {
        this.setCharset(charset);
        this.digestURI(uri);
    }

    public HttpUrlBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    private List<StringNameValuePair> parseQuery(String query, Charset charset) {
        if (query != null && !query.isEmpty()) {
            return HttpUrlEncodes.parse(query, charset);
        }
        return null;
    }

    private List<String> parsePath(String path, Charset charset) {
        if (path != null && !path.isEmpty()) {
            return HttpUrlEncodes.parsePathSegments(path, charset);
        }
        return null;
    }

    public URI build() throws URISyntaxException {
        return new URI(this.buildString());
    }

    private String buildString() {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (this.encodedSchemeSpecificPart != null) {
            sb.append(this.encodedSchemeSpecificPart);
        } else {
            if (this.encodedAuthority != null) {
                sb.append("//").append(this.encodedAuthority);
            } else if (this.host != null) {
                sb.append("//");
                if (this.encodedUserInfo != null) {
                    sb.append(this.encodedUserInfo).append("@");
                } else if (this.userInfo != null) {
                    sb.append(this.encodeUserInfo(this.userInfo)).append("@");
                }
                if (Nets.isValidIpV6Address(this.host)) {
                    sb.append("[").append(this.host).append("]");
                } else {
                    sb.append(this.host);
                }
                if (this.port >= 0) {
                    sb.append(":").append(this.port);
                }
            }
            if (this.encodedPath != null) {
                sb.append(HttpUrlBuilder.normalizePath(this.encodedPath, sb.length() == 0));
            } else if (this.pathSegments != null) {
                sb.append(this.encodePath(this.pathSegments));
            }
            if (this.encodedQuery != null) {
                sb.append("?").append(this.encodedQuery);
            } else if (this.queryParams != null && !this.queryParams.isEmpty()) {
                sb.append("?").append(this.encodeUrlForm(this.queryParams));
            } else if (this.query != null) {
                sb.append("?").append(this.encodeUric(this.query));
            }
        }
        if (this.encodedFragment != null) {
            sb.append("#").append(this.encodedFragment);
        } else if (this.fragment != null) {
            sb.append("#").append(this.encodeUric(this.fragment));
        }
        return sb.toString();
    }

    private static String normalizePath(String path, boolean relative) {
        String s = path;
        if (Strings.isBlank(s)) {
            return "";
        }
        if (!relative && !s.startsWith("/")) {
            s = "/" + s;
        }
        return s;
    }

    private void digestURI(URI uri) {
        this.scheme = uri.getScheme();
        this.encodedSchemeSpecificPart = uri.getRawSchemeSpecificPart();
        this.encodedAuthority = uri.getRawAuthority();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.encodedUserInfo = uri.getRawUserInfo();
        this.userInfo = uri.getUserInfo();
        this.encodedPath = uri.getRawPath();
        this.pathSegments = this.parsePath(uri.getRawPath(), this.charset != null ? this.charset : Charsets.UTF_8);
        this.encodedQuery = uri.getRawQuery();
        this.queryParams = this.parseQuery(uri.getRawQuery(), this.charset != null ? this.charset : Charsets.UTF_8);
        this.encodedFragment = uri.getRawFragment();
        this.fragment = uri.getFragment();
    }

    private String encodeUserInfo(String userInfo) {
        return HttpUrlEncodes.encUserInfo(userInfo, this.charset != null ? this.charset : Charsets.UTF_8);
    }

    private String encodePath(List<String> pathSegments) {
        return HttpUrlEncodes.formatSegments(pathSegments, this.charset != null ? this.charset : Charsets.UTF_8);
    }

    private String encodeUrlForm(List<StringNameValuePair> params) {
        return HttpUrlEncodes.format(params, this.charset != null ? this.charset : Charsets.UTF_8);
    }

    private String encodeUric(String fragment) {
        return HttpUrlEncodes.encUric(fragment, this.charset != null ? this.charset : Charsets.UTF_8);
    }

    public HttpUrlBuilder setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public HttpUrlBuilder setUserInfo(String userInfo) {
        this.userInfo = userInfo;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        this.encodedUserInfo = null;
        return this;
    }

    public HttpUrlBuilder setUserInfo(String username, String password) {
        return this.setUserInfo(username + ':' + password);
    }

    public HttpUrlBuilder setHost(String host) {
        this.host = host;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    public HttpUrlBuilder setPort(int port) {
        this.port = port < 0 ? -1 : port;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    public HttpUrlBuilder setPath(String path) {
        return this.setPathSegments(path != null ? HttpUrlEncodes.splitPathSegments(path) : null);
    }

    public HttpUrlBuilder setPathSegments(String ... pathSegments) {
        this.pathSegments = pathSegments.length > 0 ? Arrays.asList(pathSegments) : null;
        this.encodedSchemeSpecificPart = null;
        this.encodedPath = null;
        return this;
    }

    public HttpUrlBuilder setPathSegments(List<String> pathSegments) {
        this.pathSegments = pathSegments != null && pathSegments.size() > 0 ? new ArrayList<String>(pathSegments) : null;
        this.encodedSchemeSpecificPart = null;
        this.encodedPath = null;
        return this;
    }

    public HttpUrlBuilder removeQuery() {
        this.queryParams = null;
        this.query = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    public HttpUrlBuilder setParameters(List<StringNameValuePair> nvps) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<StringNameValuePair>();
        } else {
            this.queryParams.clear();
        }
        this.queryParams.addAll(nvps);
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public HttpUrlBuilder addParameters(List<StringNameValuePair> nvps) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<StringNameValuePair>();
        }
        this.queryParams.addAll(nvps);
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public HttpUrlBuilder setParameters(StringNameValuePair ... nvps) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<StringNameValuePair>();
        } else {
            this.queryParams.clear();
        }
        for (StringNameValuePair nvp : nvps) {
            this.queryParams.add(nvp);
        }
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public HttpUrlBuilder addParameter(String param, String value) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<StringNameValuePair>();
        }
        this.queryParams.add(new StringNameValuePair(param, value));
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public HttpUrlBuilder setParameter(String param, String value) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<StringNameValuePair>();
        }
        if (!this.queryParams.isEmpty()) {
            Iterator<StringNameValuePair> it = this.queryParams.iterator();
            while (it.hasNext()) {
                StringNameValuePair nvp = it.next();
                if (!nvp.getName().equals(param)) continue;
                it.remove();
            }
        }
        this.queryParams.add(new StringNameValuePair(param, value));
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public HttpUrlBuilder clearParameters() {
        this.queryParams = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    public HttpUrlBuilder setCustomQuery(String query) {
        this.query = query;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.queryParams = null;
        return this;
    }

    public HttpUrlBuilder setFragment(String fragment) {
        this.fragment = fragment;
        this.encodedFragment = null;
        return this;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.pathSegments == null && this.encodedPath == null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isPathEmpty() {
        return !(this.pathSegments != null && !this.pathSegments.isEmpty() || this.encodedPath != null && !this.encodedPath.isEmpty());
    }

    public List<String> getPathSegments() {
        return this.pathSegments != null ? new ArrayList<String>(this.pathSegments) : Collections.emptyList();
    }

    public String getPath() {
        if (this.pathSegments == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String segment : this.pathSegments) {
            result.append('/').append(segment);
        }
        return result.toString();
    }

    public boolean isQueryEmpty() {
        return (this.queryParams == null || this.queryParams.isEmpty()) && this.encodedQuery == null;
    }

    public List<StringNameValuePair> getQueryParams() {
        return this.queryParams != null ? new ArrayList<StringNameValuePair>(this.queryParams) : Collections.emptyList();
    }

    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        return this.buildString();
    }
}

