/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.file.comparator;

import com.jn.langx.util.io.file.Files;
import java.io.File;
import java.io.Serializable;
import java.util.Comparator;

public class SizeFileComparator
implements Comparator<File>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean sumDirectoryContents;

    public SizeFileComparator() {
        this.sumDirectoryContents = false;
    }

    public SizeFileComparator(boolean sumDirectoryContents) {
        this.sumDirectoryContents = sumDirectoryContents;
    }

    @Override
    public int compare(File file1, File file2) {
        long size1 = 0L;
        size1 = file1.isDirectory() ? (this.sumDirectoryContents && file1.exists() ? Files.sizeOfDirectory(file1) : 0L) : file1.length();
        long size2 = 0L;
        size2 = file2.isDirectory() ? (this.sumDirectoryContents && file2.exists() ? Files.sizeOfDirectory(file2) : 0L) : file2.length();
        long result = size1 - size2;
        if (result < 0L) {
            return -1;
        }
        if (result > 0L) {
            return 1;
        }
        return 0;
    }
}

