/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.file;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import java.util.LinkedList;

public class Filenames {
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String CURRENT_PATH = ".";
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String PARENT_PATH = "..";

    public static boolean checkFileSegment(String filename) {
        return filename.matches("^[^\\\\/:\\*\\?\">\\|<]+(\\.[^\\\\/:\\*\\?\">\\|<]+)?$");
    }

    public static boolean checkFilePath(String filePath) {
        int partitionSeparatorIndex;
        String partition = (filePath = Filenames.asUnixFilePath(filePath)).substring(0, partitionSeparatorIndex = filePath.indexOf(":"));
        if (Strings.isNotBlank(partition) && !Filenames.checkFileSegment(partition)) {
            return false;
        }
        filePath = filePath.substring(partitionSeparatorIndex + 1);
        filePath = filePath.replaceAll("\\\\+", FOLDER_SEPARATOR);
        String[] pathSegments = Strings.split(filePath, FOLDER_SEPARATOR);
        return Collects.allMatch(Collects.asList(pathSegments), new Predicate<String>(){

            @Override
            public boolean test(String pathSegment) {
                return Filenames.checkFileSegment(pathSegment);
            }
        });
    }

    public static String cleanPath(String path) {
        int i;
        if (Strings.isEmpty(path)) {
            return path;
        }
        String pathToUse = Strings.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(58);
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.contains(FOLDER_SEPARATOR)) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = Strings.split(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (PARENT_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, PARENT_PATH);
        }
        if (pathElements.size() == 1 && "".equals(pathElements.getLast()) && !prefix.endsWith(FOLDER_SEPARATOR)) {
            pathElements.add(0, CURRENT_PATH);
        }
        return prefix + Strings.join(FOLDER_SEPARATOR, pathElements);
    }

    public static String asUnixFilePath(String filePath) {
        Preconditions.checkNotNull(filePath);
        return filePath.trim().replaceAll("\\\\", FOLDER_SEPARATOR).replaceAll("/+", FOLDER_SEPARATOR);
    }

    public static String getParentPath(String filepath) {
        String filename = Filenames.extractFilename(filepath);
        return filepath.substring(0, filepath.length() - filename.length());
    }

    public static String extractFilename(String filePath) {
        return Filenames.extractFilename(filePath, true);
    }

    public static String extractFilename(String filePath, boolean containsSuffix) {
        Preconditions.checkTrue(Strings.isNotBlank(filePath));
        int lastFileSeparatorIndex = Filenames.asUnixFilePath(filePath).lastIndexOf(FOLDER_SEPARATOR);
        String fileName = filePath.substring(lastFileSeparatorIndex + 1);
        if (containsSuffix) {
            return fileName;
        }
        int suffixIndex = fileName.lastIndexOf(CURRENT_PATH);
        if (suffixIndex > 0 && suffixIndex != fileName.length() - 1) {
            return fileName.substring(0, suffixIndex);
        }
        return fileName;
    }

    public static String getSuffix(String filePath) {
        String filename = Filenames.extractFilename(filePath);
        int index = filename.lastIndexOf(CURRENT_PATH);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String getSuffixAsLowCase(String filename) {
        return Filenames.getSuffix(filename).toLowerCase();
    }

    public static String getSuffixAsUpperCase(String filename) {
        return Filenames.getSuffix(filename).toUpperCase();
    }
}

