/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.close;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.io.Closer;
import com.jn.langx.util.io.close.ForceCloser;
import com.jn.langx.util.reflect.Reflects;
import java.util.Map;
import java.util.ServiceLoader;

public class ObjectCloser {
    private static Map<Class, Closer> closerMap = Collects.emptyHashMap(true);
    private static ForceCloser forceCloser = new ForceCloser();

    public static void register(final Closer closer) {
        if (closer != null) {
            Collects.forEach(closer.applyTo(), new Consumer<Class>(){

                @Override
                public void accept(Class aClass) {
                    closerMap.put(aClass, closer);
                }
            });
        }
    }

    public static void close(Object obj) {
        if (obj == null) {
            return;
        }
        Class<?> type = obj.getClass();
        ObjectCloser.findCloser(type).close(obj);
    }

    private static Closer findCloser(final Class type) {
        Class t;
        Preconditions.checkNotNull(type);
        Closer closer = closerMap.get(type);
        if (closer == null && (t = Collects.findFirst(closerMap.keySet(), new Predicate<Class>(){

            @Override
            public boolean test(Class expectClass) {
                return Reflects.isSubClassOrEquals(expectClass, type);
            }
        })) != null) {
            closer = closerMap.get(t);
        }
        if (closer == null) {
            closer = forceCloser;
        }
        return closer;
    }

    static {
        Collects.forEach(ServiceLoader.load(Closer.class), new Consumer<Closer>(){

            @Override
            public void accept(Closer closer) {
                ObjectCloser.register(closer);
            }
        });
    }
}

