/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.hash.streaming.crc;

import com.jn.langx.util.hash.streaming.crc.CrcAlgoMetadata;

class CrcCalculator {
    private CrcAlgoMetadata metadata;
    private byte hashSize;
    private long mask = -1L;
    private long[] table = new long[256];

    CrcCalculator(CrcAlgoMetadata parameters) {
        this.metadata = parameters;
        this.hashSize = (byte)parameters.getHashSize();
        if (this.hashSize < 64) {
            this.mask = (1L << this.hashSize) - 1L;
        }
        this.createTable();
    }

    long hash(byte[] data) {
        return this.hash(data, 0, data.length);
    }

    long hash(byte[] data, int offset, int length) {
        long init = this.getInit();
        long hash = this.update(init, data, offset, length);
        return this.getHashResult(hash);
    }

    long getInit() {
        long init = this.metadata.isRefOut() ? CrcCalculator.reverseBits(this.metadata.getInit(), this.hashSize) : this.metadata.getInit();
        return init;
    }

    long getHashResult(long hash) {
        return (hash ^ this.metadata.getXorOut()) & this.mask;
    }

    long update(long init, byte[] data, int offset, int length) {
        long crc = init;
        if (this.metadata.isRefOut()) {
            for (int i = offset; i < offset + length; ++i) {
                crc = this.table[(int)((crc ^ (long)data[i]) & 0xFFL)] ^ crc >>> 8;
                crc &= this.mask;
            }
        } else {
            int toRight = this.hashSize - 8;
            toRight = Math.max(toRight, 0);
            for (int i = offset; i < offset + length; ++i) {
                crc = this.table[(int)((crc >> toRight ^ (long)data[i]) & 0xFFL)] ^ crc << 8;
                crc &= this.mask;
            }
        }
        return crc;
    }

    private void createTable() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = this.createTableEntry(i);
        }
    }

    private long createTableEntry(int index) {
        long r = index;
        if (this.metadata.isRefIn()) {
            r = CrcCalculator.reverseBits(r, this.hashSize);
        } else if (this.hashSize > 8) {
            r <<= this.hashSize - 8;
        }
        long lastBit = 1L << this.hashSize - 1;
        for (int i = 0; i < 8; ++i) {
            if ((r & lastBit) != 0L) {
                r = r << 1 ^ this.metadata.getPoly();
                continue;
            }
            r <<= 1;
        }
        if (this.metadata.isRefOut()) {
            r = CrcCalculator.reverseBits(r, this.hashSize);
        }
        return r & this.mask;
    }

    public CrcAlgoMetadata getMetadata() {
        return this.metadata;
    }

    static long reverseBits(long ul, int valueLength) {
        long newValue = 0L;
        for (int i = valueLength - 1; i >= 0; --i) {
            newValue |= (ul & 1L) << i;
            ul >>= 1;
        }
        return newValue;
    }
}

