/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.hash.streaming;

import com.jn.langx.util.hash.AbstractHasher;
import com.jn.langx.util.hash.StreamingHasher;
import com.jn.langx.util.hash.streaming.AbstractStreamingHasher;

public class JenkinsHasher
extends AbstractStreamingHasher {
    private static long INT_MASK = 0xFFFFFFFFL;
    private static long BYTE_MASK = 255L;
    private static JenkinsHasher _instance = new JenkinsHasher();
    private long h;

    public static StreamingHasher getInstance() {
        return _instance;
    }

    public JenkinsHasher() {
        this.reset();
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.h = seed;
    }

    @Override
    public void update(byte[] bytes, int off, int len) {
        byte[] bs = new byte[len];
        System.arraycopy(bytes, off, bs, 0, len);
        this.h = this.updateInternal(bs, bs.length, this.h);
    }

    @Override
    public long getHash() {
        long r = this.h;
        this.reset();
        return r;
    }

    @Override
    protected AbstractHasher createInstance(Object initParam) {
        return new JenkinsHasher();
    }

    private static long rot(long val, int pos) {
        return (long)Integer.rotateLeft((int)(val & INT_MASK), pos) & INT_MASK;
    }

    private long updateInternal(byte[] key, int nbytes, long initValue) {
        int length;
        long c;
        long b = c = 3735928559L + (long)length + initValue & INT_MASK;
        long a = c;
        int offset = 0;
        for (length = nbytes; length > 12; length -= 12) {
            a = a + ((long)key[offset + 0] & BYTE_MASK) & INT_MASK;
            a = a + (((long)key[offset + 1] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            a = a + (((long)key[offset + 2] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            a = a + (((long)key[offset + 3] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            b = b + ((long)key[offset + 4] & BYTE_MASK) & INT_MASK;
            b = b + (((long)key[offset + 5] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            b = b + (((long)key[offset + 6] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            b = b + (((long)key[offset + 7] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            c = c + ((long)key[offset + 8] & BYTE_MASK) & INT_MASK;
            c = c + (((long)key[offset + 9] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            c = c + (((long)key[offset + 10] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            c = c + (((long)key[offset + 11] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            a = a - c & INT_MASK;
            a ^= JenkinsHasher.rot(c, 4);
            c = c + b & INT_MASK;
            b = b - a & INT_MASK;
            b ^= JenkinsHasher.rot(a, 6);
            a = a + c & INT_MASK;
            c = c - b & INT_MASK;
            c ^= JenkinsHasher.rot(b, 8);
            b = b + a & INT_MASK;
            a = a - c & INT_MASK;
            a ^= JenkinsHasher.rot(c, 16);
            c = c + b & INT_MASK;
            b = b - a & INT_MASK;
            b ^= JenkinsHasher.rot(a, 19);
            a = a + c & INT_MASK;
            c = c - b & INT_MASK;
            c ^= JenkinsHasher.rot(b, 4);
            b = b + a & INT_MASK;
            offset += 12;
        }
        switch (length) {
            case 12: {
                c = c + (((long)key[offset + 11] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            }
            case 11: {
                c = c + (((long)key[offset + 10] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            }
            case 10: {
                c = c + (((long)key[offset + 9] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            }
            case 9: {
                c = c + ((long)key[offset + 8] & BYTE_MASK) & INT_MASK;
            }
            case 8: {
                b = b + (((long)key[offset + 7] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            }
            case 7: {
                b = b + (((long)key[offset + 6] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            }
            case 6: {
                b = b + (((long)key[offset + 5] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            }
            case 5: {
                b = b + ((long)key[offset + 4] & BYTE_MASK) & INT_MASK;
            }
            case 4: {
                a = a + (((long)key[offset + 3] & BYTE_MASK) << 24 & INT_MASK) & INT_MASK;
            }
            case 3: {
                a = a + (((long)key[offset + 2] & BYTE_MASK) << 16 & INT_MASK) & INT_MASK;
            }
            case 2: {
                a = a + (((long)key[offset + 1] & BYTE_MASK) << 8 & INT_MASK) & INT_MASK;
            }
            case 1: {
                a = a + ((long)key[offset + 0] & BYTE_MASK) & INT_MASK;
                break;
            }
            case 0: {
                return (int)(c & INT_MASK);
            }
        }
        c ^= b;
        c = c - JenkinsHasher.rot(b, 14) & INT_MASK;
        a ^= c;
        a = a - JenkinsHasher.rot(c, 11) & INT_MASK;
        b ^= a;
        b = b - JenkinsHasher.rot(a, 25) & INT_MASK;
        c ^= b;
        c = c - JenkinsHasher.rot(b, 16) & INT_MASK;
        a ^= c;
        a = a - JenkinsHasher.rot(c, 4) & INT_MASK;
        b ^= a;
        b = b - JenkinsHasher.rot(a, 14) & INT_MASK;
        c ^= b;
        c = c - JenkinsHasher.rot(b, 24) & INT_MASK;
        return (int)(c & INT_MASK);
    }
}

