/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.hash;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.hash.Hasher;
import com.jn.langx.util.reflect.Reflects;

public abstract class AbstractHasher
implements Hasher {
    protected long seed;

    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public long hash(byte[] bytes) {
        return this.hash(bytes, bytes.length, 0L);
    }

    @Override
    public long hash(byte[] bytes, long seed) {
        return this.hash(bytes, bytes.length, seed);
    }

    @Override
    public abstract long hash(byte[] var1, int var2, long var3);

    @Override
    public String getName() {
        String name = Reflects.getSimpleClassName(this);
        if (name.endsWith("Hasher")) {
            name = name.substring(0, name.length() - "Hasher".length());
        }
        name = Strings.lowerCase(name);
        return name;
    }

    @Override
    public final Hasher get(Object initParams) {
        AbstractHasher hasher = this.createInstance(initParams);
        hasher.setSeed(0L);
        return hasher;
    }

    protected AbstractHasher createInstance(Object initParams) {
        throw new UnsupportedOperationException();
    }

    protected long toLong(byte[] bytes) {
        try {
            return this.asLong(bytes);
        }
        catch (IllegalStateException ex) {
            return this.asInt(bytes);
        }
    }

    protected int asInt(byte[] bytes) {
        Preconditions.checkState(bytes.length >= 4, "AbstractHasher#asInt() requires >= 4 bytes (it only has {} bytes).", bytes.length);
        return bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16 | (bytes[3] & 0xFF) << 24;
    }

    protected long asLong(byte[] bytes) {
        Preconditions.checkState(bytes.length >= 8, "AbstractHasher#asLong() requires >= 8 bytes (it only has {} bytes).", bytes.length);
        return this.padToLong(bytes);
    }

    protected long padToLong(byte[] bytes) {
        long retVal = bytes[0] & 0xFF;
        for (int i = 1; i < Math.min(bytes.length, 8); ++i) {
            retVal |= ((long)bytes[i] & 0xFFL) << i * 8;
        }
        return retVal;
    }
}

