/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.enums;

import com.jn.langx.Named;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.enums.base.CommonEnum;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.reflect.Reflects;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class Enums {
    private Enums() {
    }

    public static <T extends Enum<T>> T ofValue(final int value, Class<T> targetClass) {
        Preconditions.checkTrue(targetClass.isEnum(), targetClass.getName() + " not an enum class");
        return (T)((Enum)Collects.findFirst(EnumSet.allOf(targetClass), new Predicate<T>(){

            @Override
            public boolean test(T e) {
                return ((Enum)e).ordinal() == value;
            }
        }));
    }

    public static <T extends Enum<T>> T ofCode(@NonNull Class<T> tClass, final int code) {
        Preconditions.checkNotNull(tClass);
        Enum t = null;
        if (Reflects.isSubClass(CommonEnum.class, tClass)) {
            t = (Enum)Collects.findFirst(EnumSet.allOf(tClass), new Predicate<T>(){

                @Override
                public boolean test(T e) {
                    CommonEnum y = (CommonEnum)e;
                    return y.getCode() == code;
                }
            });
        }
        if (t == null) {
            t = (Enum)Collects.findFirst(EnumSet.allOf(tClass), new Predicate<T>(){

                @Override
                public boolean test(T e) {
                    return ((Enum)e).ordinal() == code;
                }
            });
        }
        return (T)t;
    }

    public static <T extends Enum<T>> T ofName(@NonNull Class<T> tClass, final String name) {
        Preconditions.checkNotNull(tClass);
        Enum t = null;
        if (Reflects.isSubClass(CommonEnum.class, tClass)) {
            t = (Enum)Collects.findFirst(EnumSet.allOf(tClass), new Predicate<T>(){

                @Override
                public boolean test(T e) {
                    CommonEnum y = (CommonEnum)e;
                    return y.getName().equals(name);
                }
            });
        }
        if (t == null && Reflects.isSubClass(Named.class, tClass)) {
            t = (Enum)Collects.findFirst(EnumSet.allOf(tClass), new Predicate<T>(){

                @Override
                public boolean test(T e) {
                    Named y = (Named)e;
                    return y.getName().equals(name);
                }
            });
        }
        if (t == null) {
            t = (Enum)Collects.findFirst(EnumSet.allOf(tClass), new Predicate<T>(){

                @Override
                public boolean test(T e) {
                    return ((Enum)e).name().equals(name);
                }
            });
        }
        if (t == null) {
            t = Enums.ofField(tClass, "name", name);
        }
        return (T)t;
    }

    public static <T extends Enum<T>> T ofToString(@NonNull Class<T> tClass, final String value) {
        Preconditions.checkNotNull(tClass);
        Enum t = null;
        if (Reflects.isSubClass(CommonEnum.class, tClass)) {
            t = (Enum)Collects.findFirst(EnumSet.allOf(tClass), new Predicate<T>(){

                @Override
                public boolean test(T e) {
                    CommonEnum y = (CommonEnum)e;
                    return y.toString().equals(value);
                }
            });
        }
        if (t == null) {
            t = (Enum)Collects.findFirst(EnumSet.allOf(tClass), new Predicate<T>(){

                @Override
                public boolean test(T e) {
                    return ((Enum)e).toString().equals(value);
                }
            });
        }
        return (T)t;
    }

    public static <T extends Enum<T>> T ofDisplayText(@NonNull Class<T> tClass, final String displayText) {
        Preconditions.checkNotNull(tClass);
        Enum t = null;
        if (Reflects.isSubClass(CommonEnum.class, tClass)) {
            t = (Enum)Collects.findFirst(EnumSet.allOf(tClass), new Predicate<T>(){

                @Override
                public boolean test(T e) {
                    CommonEnum y = (CommonEnum)e;
                    return y.getDisplayText().equals(displayText);
                }
            });
        }
        if (t == null) {
            t = (Enum)Collects.findFirst(EnumSet.allOf(tClass), new Predicate<T>(){

                @Override
                public boolean test(T e) {
                    return ((Enum)e).name().equals(displayText);
                }
            });
        }
        return (T)t;
    }

    public static <T extends Enum<T>> T inferEnum(Class<T> targetClass, String text) {
        T v;
        if (targetClass.isEnum() && Reflects.isSubClassOrEquals(Enum.class, targetClass) && (v = Enums.ofDisplayText(targetClass, text)) == null) {
            return Enums.ofName(targetClass, text);
        }
        return null;
    }

    public static <T extends Enum<T>> T ofField(Class<T> targetClass, String field, Object value) {
        return Enums.ofField(targetClass, field, value, null);
    }

    public static <T extends Enum<T>> T ofField(Class<T> targetClass, String field, Supplier0<Object> valueSupplier) {
        return Enums.ofField(targetClass, field, valueSupplier, null);
    }

    public static <T extends Enum<T>> T ofField(Class<T> targetClass, String field, final Object value, Predicate<T> predicate) {
        return Enums.ofField(targetClass, field, new Supplier0<Object>(){

            @Override
            public Object get() {
                return value;
            }
        }, predicate);
    }

    public static <T extends Enum<T>> T ofField(Class<T> targetClass, final String field, final Supplier0<Object> valueSupplier, Predicate<T> predicate) {
        Preconditions.checkNotNull(targetClass);
        Preconditions.checkNotNull(field);
        if (targetClass.isEnum() && Reflects.isSubClassOrEquals(Enum.class, targetClass)) {
            if (predicate == null) {
                return (T)((Enum)Collects.findFirst(EnumSet.allOf(targetClass), new Predicate<T>(){

                    @Override
                    public boolean test(T e) {
                        Object fieldValue = Reflects.getAnyFieldValue(e, field, true, false);
                        Object expectedValue = valueSupplier == null ? null : valueSupplier.get();
                        return Objs.deepEquals(fieldValue, expectedValue);
                    }
                }));
            }
            return (T)((Enum)Collects.findFirst(EnumSet.allOf(targetClass), predicate));
        }
        throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("{} not a enum class", Reflects.getFQNClassName(targetClass)));
    }

    public static <T extends Enum<T>> Set<T> getEnumSet(Class<T> enumClass) {
        return EnumSet.allOf(enumClass);
    }

    public static <T extends Enum<T>> List<T> getEnumList(Class<T> enumClass) {
        return Collects.asList(Enums.getEnumSet(enumClass));
    }

    public static int getIndex(Enum e) {
        return e.ordinal();
    }

    public static int getCode(Enum e) {
        if (e instanceof CommonEnum) {
            return ((CommonEnum)((Object)e)).getCode();
        }
        return Enums.getIndex(e);
    }

    public static String getName(Enum e) {
        if (e instanceof CommonEnum) {
            return ((CommonEnum)((Object)e)).getName();
        }
        if (e instanceof Named) {
            return ((Named)((Object)e)).getName();
        }
        return e.name();
    }

    public static String getDisplayText(Enum e) {
        if (e instanceof CommonEnum) {
            return ((CommonEnum)((Object)e)).getDisplayText();
        }
        return e.name();
    }
}

