/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.compress;

import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Zips {
    private static final int BUFFER_SIZE = 8192;

    public static void uncompress(InputStream stream, File targetDir) throws IOException {
        Zips.uncompressAndRename(stream, targetDir, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void uncompressAndRename(InputStream stream, File targetDir, String renameFrom, String renameTo) throws IOException {
        ZipInputStream in = null;
        try {
            ZipEntry entry;
            in = new ZipInputStream(new BufferedInputStream(stream));
            while ((entry = in.getNextEntry()) != null) {
                String name = entry.getName();
                if (renameFrom != null && renameTo != null) {
                    name = name.replaceAll(renameFrom, renameTo);
                }
                File target = new File(targetDir, name);
                if (entry.isDirectory()) {
                    Files.makeDirs(target);
                    continue;
                }
                Files.makeDirs(target.getParentFile());
                BufferedOutputStream out = null;
                try {
                    int len;
                    out = new BufferedOutputStream(new FileOutputStream(target));
                    byte[] buffer = new byte[8192];
                    while ((len = in.read(buffer, 0, 8192)) != -1) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    IOs.close(out);
                    throw throwable;
                }
                IOs.close(out);
            }
        }
        catch (Throwable throwable) {
            IOs.close(in);
            throw throwable;
        }
        IOs.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompressFiltered(File file, File targetDir, String ... excludes) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                boolean excludeEntry = false;
                if (excludes != null) {
                    for (String exclude : excludes) {
                        if (!name.matches(exclude)) continue;
                        excludeEntry = true;
                    }
                }
                if (excludeEntry) continue;
                File target = new File(targetDir, name);
                if (entry.isDirectory()) {
                    Files.makeDirs(target);
                    continue;
                }
                Files.makeDirs(target.getParentFile());
                InputStream in = null;
                try {
                    in = zipFile.getInputStream(entry);
                    BufferedOutputStream out = null;
                    try {
                        int len;
                        out = new BufferedOutputStream(new FileOutputStream(target));
                        byte[] buffer = new byte[8192];
                        while ((len = in.read(buffer, 0, 8192)) != -1) {
                            ((OutputStream)out).write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable) {
                        IOs.close(out);
                        throw throwable;
                    }
                    IOs.close(out);
                }
                finally {
                    IOs.close(in);
                }
            }
        }
        finally {
            IOs.close(zipFile);
        }
    }

    public static boolean isZipFile(File file) {
        boolean result = false;
        try {
            ZipFile zipFile = new ZipFile(file);
            zipFile.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

