/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.comparator;

import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.reflect.Reflects;

public class Compares {
    public static <E> boolean gt(E e1, E e2) {
        if (!Reflects.isSubClassOrEquals(e1.getClass(), e2.getClass()) && !Reflects.isSubClassOrEquals(e2.getClass(), e1.getClass())) {
            throw new UnsupportedOperationException(StringTemplates.formatWithPlaceholder("unsupported operation > between {} and  {}", e1.getClass(), e2.getClass()));
        }
        if (e1 instanceof Comparable && e2 instanceof Comparable) {
            return ((Comparable)e1).compareTo(e2) > 0;
        }
        throw new UnsupportedOperationException(StringTemplates.formatWithPlaceholder("unsupported operation > between {} and  {}", e1.getClass(), e2.getClass()));
    }

    public static <E> boolean lt(E e1, E e2) {
        if (!Reflects.isSubClassOrEquals(e1.getClass(), e2.getClass()) && !Reflects.isSubClassOrEquals(e2.getClass(), e1.getClass())) {
            throw new UnsupportedOperationException(StringTemplates.formatWithPlaceholder("unsupported operation > between {} and  {}", e1.getClass(), e2.getClass()));
        }
        if (e1 instanceof Comparable && e2 instanceof Comparable) {
            return ((Comparable)e1).compareTo(e2) < 0;
        }
        throw new UnsupportedOperationException(StringTemplates.formatWithPlaceholder("unsupported operation > between {} and  {}", e1.getClass(), e2.getClass()));
    }

    public static <E> boolean eq(E e1, E e2) {
        return e1.equals(e2);
    }

    public static <E> boolean ne(E e1, E e2) {
        return !e1.equals(e2);
    }

    public static <E> boolean ge(E e1, E e2) {
        if (e1.equals(e2)) {
            return true;
        }
        if (!Reflects.isSubClassOrEquals(e1.getClass(), e2.getClass()) && !Reflects.isSubClassOrEquals(e2.getClass(), e1.getClass())) {
            return false;
        }
        if (e1 instanceof Comparable && e2 instanceof Comparable) {
            return ((Comparable)e1).compareTo(e2) >= 0;
        }
        return false;
    }

    public static <E> boolean le(E e1, E e2) {
        if (e1.equals(e2)) {
            return true;
        }
        if (!Reflects.isSubClassOrEquals(e1.getClass(), e2.getClass()) && !Reflects.isSubClassOrEquals(e2.getClass(), e1.getClass())) {
            return false;
        }
        if (e1 instanceof Comparable && e2 instanceof Comparable) {
            return ((Comparable)e1).compareTo(e2) <= 0;
        }
        return false;
    }

    public static <E> boolean in(E e1, Object collection) {
        return Collects.asCollection(Collects.asIterable(collection)).contains(e1);
    }

    public static <E> boolean ni(E e1, Object collection) {
        return !Collects.asCollection(Collects.asIterable(collection)).contains(e1);
    }
}

