/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.buffer;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.buffer.ReadWriteBuffer;
import com.jn.langx.util.function.Consumer;
import java.util.Collection;
import java.util.List;

public class ArrayBuffer<E>
extends ReadWriteBuffer<E, ArrayBuffer<E>> {
    private E[] array;
    private int offset = 0;
    private boolean readonly = false;

    public ArrayBuffer(int maxCapacity) {
        super(-1L, 0L, maxCapacity, maxCapacity);
        this.array = new Object[maxCapacity];
    }

    public ArrayBuffer(E[] buf) {
        this(-1, 0, buf.length, buf.length, buf, 0);
    }

    public ArrayBuffer(E[] buf, int offset) {
        this(-1, offset, buf.length, buf.length, buf, 0);
    }

    public ArrayBuffer(E[] buf, int offset, int length) {
        this(-1, offset, offset + length, buf.length, buf, 0);
    }

    public ArrayBuffer(int mark, int pos, int lim, int cap, E[] buf, int offset) {
        super(mark, pos, lim, cap);
        this.array = buf;
        this.offset = offset;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public Object array() {
        return this.array;
    }

    @Override
    public long arrayOffset() {
        return this.offset;
    }

    @Override
    public ArrayBuffer<E> put(@Nullable E e) {
        Preconditions.checkState(!this.readonly, "the buffer is readonly");
        this.array[(int)this.idx((long)this.nextPutIndex())] = e;
        return this;
    }

    @Override
    public ArrayBuffer<E> put(long index, @Nullable E e) {
        Preconditions.checkState(!this.readonly, "the buffer is readonly");
        this.array[(int)this.idx((long)this.checkIndex((long)index))] = e;
        return this;
    }

    @Override
    public ArrayBuffer<E> put(E[] es) {
        this.put((Collection)Collects.newArrayList(es));
        return this;
    }

    @Override
    public ArrayBuffer<E> put(Collection<E> es) {
        Collects.forEach(es, new Consumer<E>(){

            @Override
            public void accept(E e) {
                ArrayBuffer.this.put(e);
            }
        });
        return this;
    }

    private long idx(long position) {
        return (long)this.offset + position;
    }

    @Override
    public E get() {
        return this.array[(int)this.idx(this.nextGetIndex())];
    }

    @Override
    public E get(long index) {
        return this.array[(int)this.idx(this.checkIndex(index))];
    }

    @Override
    public List<E> get(long index, long maxLength) {
        Preconditions.checkArgument(maxLength >= 0L);
        List<E> list = Collects.emptyArrayList();
        for (long len = Maths.minLong(this.limit() - this.checkIndex(index), maxLength); len >= 0L; --len) {
            list.add(this.get(index++));
        }
        return list;
    }
}

