/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.bloom;

import com.jn.langx.util.bloom.Key;
import com.jn.langx.util.hash.Hasher;
import com.jn.langx.util.hash.Hashs;

public final class HashFunction {
    private int nbHash;
    private int maxValue;
    private Hasher hasher;

    public HashFunction(int maxValue, int nbHash, String hasherName) {
        this(maxValue, nbHash, hasherName, null);
    }

    public HashFunction(int maxValue, int nbHash, String hasherName, Object hasherInitParams) {
        if (maxValue <= 0) {
            throw new IllegalArgumentException("maxValue must be > 0");
        }
        if (nbHash <= 0) {
            throw new IllegalArgumentException("nbHash must be > 0");
        }
        this.maxValue = maxValue;
        this.nbHash = nbHash;
        this.hasher = Hashs.getHasher(hasherName, hasherInitParams);
    }

    public void clear() {
    }

    public int[] hash(Key k) {
        byte[] b = k.getBytes();
        if (b == null) {
            throw new NullPointerException("buffer reference is null");
        }
        if (b.length == 0) {
            throw new IllegalArgumentException("key length must be > 0");
        }
        int[] result = new int[this.nbHash];
        long h = 0L;
        for (int i = 0; i < this.nbHash; ++i) {
            h = Hashs.hash(this.hasher, b, h);
            result[i] = Math.abs(Long.valueOf(h).intValue() % this.maxValue);
        }
        return result;
    }
}

