/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.function.Supplier0;
import java.util.Arrays;
import java.util.Comparator;

public abstract class Objs {
    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean deepEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (a.getClass().isArray() && b.getClass().isArray()) {
            return Arrs.deepEquals(a, b);
        }
        return false;
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static int hash(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static String toString(Object o) {
        return String.valueOf(o);
    }

    public static String toString(Object o, String nullDefault) {
        return o != null ? o.toString() : nullDefault;
    }

    public static String toStringOrNull(Object o) {
        return o != null ? o.toString() : null;
    }

    public static <T> int compare(T a, T b, Comparator<? super T> c) {
        return a == b ? 0 : c.compare(a, b);
    }

    public static <T> T requireNonNull(T obj) {
        return Preconditions.checkNotNull(obj);
    }

    public static <T> T requireNonNull(T obj, String message) {
        return Preconditions.checkNotNull(obj, message);
    }

    public static boolean isNull(Object obj) {
        return Emptys.isNull(obj);
    }

    public static boolean isNotNull(Object obj) {
        return Emptys.isNotNull(obj);
    }

    public static boolean nonNull(Object obj) {
        return Emptys.isNotNull(obj);
    }

    public static <T> T requireNonNull(T obj, Supplier<Object[], String> messageSupplier, Object ... params) {
        return Preconditions.checkNotNull(obj, messageSupplier, params);
    }

    public static <T> T requireNonNull(T obj, final Supplier0<String> messageSupplier) {
        return Preconditions.checkNotNull(obj, new Supplier<Object[], String>(){

            @Override
            public String get(Object[] input) {
                return (String)messageSupplier.get();
            }
        }, new Object[0]);
    }

    public static <T> T useValueIfNull(T value, T defaultValue) {
        return Objs.useValueIfMatch(value, Functions.nullPredicate(), defaultValue);
    }

    public static <T> T useValueIfEmpty(T value, T defaultValue) {
        return Objs.useValueIfMatch(value, Functions.emptyPredicate(), defaultValue);
    }

    public static <T> T useValueIfNull(T value, Supplier<T, T> supplier) {
        return Objs.useValueIfMatch(value, Functions.nullPredicate(), supplier);
    }

    public static <T> T useValueIfEmpty(T value, Supplier<T, T> supplier) {
        return Objs.useValueIfMatch(value, Functions.emptyPredicate(), supplier);
    }

    public static <T> T useValueIfMatch(T value, Predicate<T> predicate, T defaultValue) {
        if (predicate.test(value)) {
            return defaultValue;
        }
        return value;
    }

    public static <T> T useValueIfNotMatch(T value, Predicate<T> predicate, T defaultValue) {
        if (!predicate.test(value)) {
            return defaultValue;
        }
        return value;
    }

    public static <T> T useValueIfMatch(T value, Predicate<T> predicate, Supplier<T, T> defaultSupplier) {
        if (predicate.test(value)) {
            return defaultSupplier.get(value);
        }
        return value;
    }

    public static <T> T useValueIfMatch(@NonNull Supplier0<T> valueSupplier, Predicate<T> predicate, Supplier<T, T> defaultSupplier) {
        T value = null;
        if (valueSupplier != null) {
            value = valueSupplier.get();
        }
        return Objs.useValueIfMatch(value, predicate, defaultSupplier);
    }

    public static <T> T useValueIfNotMatch(T value, Predicate<T> predicate, Supplier<T, T> supplier) {
        if (!predicate.test(value)) {
            return supplier.get(value);
        }
        return value;
    }

    public static <T> T useValueIfNotMatch(@NonNull Supplier0<T> valueSupplier, Predicate<T> predicate, Supplier<T, T> defaultSupplier) {
        T value = null;
        if (valueSupplier != null) {
            value = valueSupplier.get();
        }
        return Objs.useValueIfMatch(value, predicate, defaultSupplier);
    }

    public static int checkIndex(int index, int length) {
        return Preconditions.checkIndex(index, length, null);
    }

    public static int checkFromToIndex(int fromIndex, int toIndex, int length) {
        return Preconditions.checkFromToIndex(fromIndex, toIndex, length, null);
    }

    public static int checkFromIndexSize(int fromIndex, int size, int length) {
        return Preconditions.checkFromIndexSize(fromIndex, size, length, null);
    }

    public static boolean isEmpty(Object o) {
        return Emptys.isEmpty(o);
    }

    public static boolean isNotEmpty(Object o) {
        return Emptys.isNotEmpty(o);
    }

    public static <T> int length(T object) {
        return Emptys.getLength(object);
    }

    public static Object[] swap(Object obj1, Object obj2) {
        Object temp = obj1;
        obj1 = obj2;
        obj2 = temp;
        return new Object[]{obj1, obj2};
    }
}

