/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.xml;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.text.xml.Namespace;
import com.jn.langx.text.xml.NodeAttributesIterator;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Namespaces {
    public static String NAMESPACE_XSI_NAME = "xsi";

    public static String getNodeNamespaceURI(@NonNull Node node) {
        return node.getNamespaceURI();
    }

    public static boolean isNamespaceAttribute(Attr attribute) {
        return "xmlns".equals(attribute.getLocalName()) || ("xmlns:" + attribute.getLocalName()).equals(attribute.getName());
    }

    public static Map<String, Namespace> getDocumentNamespaces(Node node) {
        Element root = node.getOwnerDocument().getDocumentElement();
        return Namespaces.findNamespaces(root);
    }

    public static Map<String, Namespace> findNamespaces(@NonNull Node node) {
        HashMap<String, Namespace> ret = new HashMap<String, Namespace>();
        if (node.getParentNode() != null) {
            ret.putAll(Namespaces.findNamespaces(node.getParentNode()));
        }
        ret.putAll(Pipeline.of(new NodeAttributesIterator(node)).filter(new Predicate<Attr>(){

            @Override
            public boolean test(Attr attribute) {
                return Namespaces.isNamespaceAttribute(attribute);
            }
        }).map(new Function<Attr, Namespace>(){

            @Override
            public Namespace apply(Attr attr) {
                return new Namespace(attr.getLocalName(), attr.getValue());
            }
        }).collect(Collects.toHashMap(new Function<Namespace, String>(){

            @Override
            public String apply(Namespace input) {
                return input.getPrefix();
            }
        }, new Function<Namespace, Namespace>(){

            @Override
            public Namespace apply(Namespace input) {
                return input;
            }
        }, false)));
        return ret;
    }

    public static boolean isW3cXmlNamespace(Node node) {
        return Namespaces.isCustomNamespace(node.getNamespaceURI());
    }

    public static boolean isDefaultNamespace(Namespace namespace) {
        return "xmlns".equals(namespace.getPrefix());
    }

    public static boolean hasCustomNamespace(Document document) {
        return Namespaces.hasCustomNamespace(document, false);
    }

    public static boolean hasCustomNamespace(Document document, boolean isDefaultIfJustHasXsi) {
        Map<String, Namespace> namespaceMap = Namespaces.getDocumentNamespaces(document.getDocumentElement());
        if (Pipeline.of(namespaceMap.values()).anyMatch(new Predicate<Namespace>(){

            @Override
            public boolean test(Namespace namespace) {
                return Namespaces.isCustomNamespace(namespace);
            }
        })) {
            return !isDefaultIfJustHasXsi || namespaceMap.size() != 1 || !namespaceMap.containsKey(NAMESPACE_XSI_NAME);
        }
        return false;
    }

    public static boolean isCustomNamespace(Namespace namespace) {
        return !Namespaces.isW3cXmlNamespace(namespace);
    }

    public static boolean isCustomNamespace(String namespaceURI) {
        return !Namespaces.isW3cXmlNamespace(namespaceURI);
    }

    public static boolean isW3cXmlNamespace(Namespace namespace) {
        return Namespaces.isW3cSchemaInstanceNamespace(namespace) || Namespaces.isW3cSchemaNamespace(namespace);
    }

    public static boolean isW3cXmlNamespace(String namespaceURI) {
        return Namespaces.isW3cSchemaInstanceNamespace(namespaceURI) || Namespaces.isW3cSchemaNamespace(namespaceURI);
    }

    public static boolean isW3cSchemaNamespace(Namespace namespace) {
        return Namespaces.isW3cSchemaNamespace(namespace.getUri());
    }

    public static boolean isW3cSchemaNamespace(String namespaceURI) {
        return "http://www.w3.org/2001/XMLSchema".equals(namespaceURI);
    }

    public static boolean isW3cSchemaInstanceNamespace(Namespace namespace) {
        return Namespaces.isW3cSchemaInstanceNamespace(namespace.getUri());
    }

    public static boolean isW3cSchemaInstanceNamespace(String namespaceURI) {
        return "http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI);
    }
}

