/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.stringtemplate;

import com.jn.langx.text.stringtemplate.StringTemplate;
import com.jn.langx.text.stringtemplate.StringTemplateFormatter;
import com.jn.langx.util.function.Function2;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.Regexps;

public class CustomPatternStringFormatter
implements StringTemplateFormatter {
    private Regexp variableRegexp;
    private Function2<String, Object[], String> valueGetter;

    public CustomPatternStringFormatter() {
    }

    public CustomPatternStringFormatter(Regexp variableRegexp, Function2<String, Object[], String> valueGetter) {
        this.setVariablePattern(variableRegexp);
        this.setValueGetter(valueGetter);
    }

    public CustomPatternStringFormatter(String pattern, Function2<String, Object[], String> valueGetter) {
        this(Regexps.compile(pattern), valueGetter);
    }

    @Override
    public String format(String template, Object ... args) {
        return new StringTemplate().variablePattern(this.variableRegexp).using(template).with(this.valueGetter).format(args);
    }

    public Regexp getVariablePattern() {
        return this.variableRegexp;
    }

    public void setVariablePattern(Regexp variablePattern) {
        this.variableRegexp = variablePattern;
    }

    public Function2<String, Object[], String> getValueGetter() {
        return this.valueGetter;
    }

    public void setValueGetter(Function2<String, Object[], String> valueGetter) {
        this.valueGetter = valueGetter;
    }
}

