/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.ssl;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Arrs;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class PrivateKeyDetails {
    private final String type;
    private final X509Certificate[] certChain;

    public PrivateKeyDetails(String type, X509Certificate[] certChain) {
        this.type = Preconditions.checkNotNull(type, "Private key type");
        this.certChain = Arrs.copy(certChain);
    }

    public String getType() {
        return this.type;
    }

    public X509Certificate[] getCertChain() {
        return Arrs.copy(this.certChain);
    }

    public String toString() {
        return this.type + ':' + Arrays.toString(this.certChain);
    }
}

