/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.digest;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.codec.base64.Base64;
import com.jn.langx.codec.hex.Hex;
import com.jn.langx.security.crypto.AlgorithmUnregisteredException;
import com.jn.langx.security.crypto.digest.MessageDigests;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Maths;
import com.jn.langx.util.collection.PrimitiveArrays;
import java.security.MessageDigest;

public class MessageDigestHasher {
    private static final int DEFAULT_ITERATIONS = 1;
    private byte[] salt = null;
    private int iterations = 1;
    private String algorithmName;

    public byte[] getSalt() {
        return PrimitiveArrays.copy(this.salt);
    }

    public void setSalt(byte[] salt) {
        if (salt != null) {
            this.salt = PrimitiveArrays.copy(salt);
        }
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = Maths.max(1, iterations);
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        if (Emptys.isNotEmpty(algorithmName)) {
            this.algorithmName = algorithmName;
        }
    }

    public MessageDigestHasher(@NonNull String algorithmName) {
        this(algorithmName, null);
    }

    public MessageDigestHasher(@NonNull String algorithmName, byte[] salt) {
        this(algorithmName, salt, 1);
    }

    public MessageDigestHasher(@NonNull String algorithmName, @Nullable byte[] salt, int hashIterations) {
        this.setAlgorithmName(algorithmName);
        this.setIterations(hashIterations);
        this.setSalt(salt);
    }

    public byte[] hash(byte[] source) {
        return this.doHash(source, this.salt, this.iterations);
    }

    public String hashToHexString(byte[] source, boolean lowerCase) {
        byte[] hashed = this.hash(source);
        return Hex.encodeHexString(hashed, lowerCase);
    }

    public String hashToBase64String(byte[] source) {
        byte[] hashed = this.hash(source);
        return Base64.encodeBase64String(hashed);
    }

    protected byte[] doHash(byte[] data, byte[] salt, int iterations) {
        MessageDigest digest = MessageDigests.newDigest(this.algorithmName);
        if (digest == null) {
            throw new AlgorithmUnregisteredException(this.algorithmName);
        }
        byte[] bytes = data;
        if (Emptys.isNotEmpty(salt)) {
            digest.reset();
            bytes = digest.digest(salt);
        }
        iterations = Maths.max(1, iterations);
        for (int i = 0; i < iterations; ++i) {
            digest.reset();
            bytes = digest.digest(bytes);
        }
        return bytes;
    }
}

