/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.management.connector.local.jndi;

import com.jn.langx.management.ConnectorConfiguration;
import com.jn.langx.management.JMXConnection;
import com.jn.langx.management.JMXConnectionFactory;
import com.jn.langx.management.connector.local.JMXLocalConnection;
import com.jn.langx.management.connector.local.jndi.JndiConfiguration;
import com.jn.langx.util.logging.Loggers;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import org.slf4j.Logger;

public class JndiLocalConnectionFactory
implements JMXConnectionFactory {
    private static final String DEFAULT_CONTEXT_FACTORY = "com.sun.InitialContextFactroy";

    @Override
    public JMXConnection getConnection(ConnectorConfiguration config) {
        JndiConfiguration jndiConfig = (JndiConfiguration)config;
        String jndi = jndiConfig.getServerJndi();
        MBeanServer server = null;
        try {
            String jndiFactroyClass = jndiConfig.getJndiFactoryClass();
            if (jndiFactroyClass == null || jndiFactroyClass.isEmpty()) {
                jndiFactroyClass = DEFAULT_CONTEXT_FACTORY;
                jndiConfig.setProperty("java.naming.factory.initial", jndiFactroyClass);
            }
            InitialContext context = new InitialContext(jndiConfig.getProperties());
            server = (MBeanServer)context.lookup(jndi);
        }
        catch (Throwable t) {
            Logger logger = Loggers.getLogger(this.getClass());
            logger.error(t.getMessage(), t);
        }
        if (server != null) {
            return new JMXLocalConnection(server);
        }
        return null;
    }
}

