/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.management;

import com.jn.langx.management.MBeanException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;

public abstract class JMXConnection
implements Closeable {
    protected MBeanServerConnection conn;

    public MBeanServerConnection getRealConn() {
        return this.conn;
    }

    public JMXConnection(MBeanServerConnection conn) {
        this.conn = conn;
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws MBeanException {
        try {
            return this.conn.createMBean(className, name);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws MBeanException {
        try {
            return this.conn.createMBean(className, name, loaderName);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws MBeanException {
        try {
            return this.conn.createMBean(className, name, params, signature);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws MBeanException {
        try {
            return this.conn.createMBean(className, name, loaderName, params, signature);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public void unregisterMBean(ObjectName name) throws MBeanException {
        try {
            this.conn.unregisterMBean(name);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws MBeanException {
        try {
            return this.conn.getObjectInstance(name);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws MBeanException {
        try {
            return this.conn.queryMBeans(name, query);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws MBeanException {
        try {
            return this.conn.queryNames(name, query);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public boolean isRegistered(ObjectName name) throws MBeanException {
        try {
            return this.conn.isRegistered(name);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public Integer getMBeanCount() throws MBeanException {
        try {
            return this.conn.getMBeanCount();
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException {
        try {
            return this.conn.getAttribute(name, attribute);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws MBeanException {
        try {
            return this.conn.getAttributes(name, attributes);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws MBeanException {
        try {
            this.conn.setAttribute(name, attribute);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws MBeanException {
        try {
            return this.conn.setAttributes(name, attributes);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws MBeanException {
        try {
            return this.conn.invoke(name, operationName, params, signature);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public String getDefaultDomain() throws MBeanException {
        try {
            return this.conn.getDefaultDomain();
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public String[] getDomains() throws MBeanException {
        try {
            return this.conn.getDomains();
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws MBeanException {
        try {
            this.conn.addNotificationListener(name, listener, filter, handback);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws MBeanException {
        try {
            this.conn.addNotificationListener(name, listener, filter, handback);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws MBeanException {
        try {
            this.conn.removeNotificationListener(name, listener);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws MBeanException {
        try {
            this.conn.removeNotificationListener(name, listener, filter, handback);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws MBeanException {
        try {
            this.conn.removeNotificationListener(name, listener);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws MBeanException {
        try {
            this.conn.removeNotificationListener(name, listener, filter, handback);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws MBeanException {
        try {
            return this.conn.getMBeanInfo(name);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public boolean isInstanceOf(ObjectName name, String className) throws MBeanException {
        try {
            return this.conn.isInstanceOf(name, className);
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
    }

    public boolean hasMBean(ObjectName oname) {
        boolean hasObject = false;
        try {
            MBeanInfo mbeanInfo = this.conn.getMBeanInfo(oname);
            if (mbeanInfo != null) {
                hasObject = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hasObject;
    }

    public boolean hasAttribute(ObjectName oname, String attributeName) throws MBeanException {
        boolean hasAttribute = false;
        try {
            MBeanAttributeInfo[] arr;
            MBeanInfo mbeanInfo = this.getMBeanInfo(oname);
            for (MBeanAttributeInfo attr : arr = mbeanInfo.getAttributes()) {
                if (!attr.getName().equals(attributeName)) continue;
                hasAttribute = true;
                break;
            }
        }
        catch (Throwable ex) {
            throw new MBeanException(ex);
        }
        return hasAttribute;
    }

    @Override
    public abstract void close() throws IOException;
}

