/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.management;

import com.jn.langx.management.JMXConnection;
import com.jn.langx.management.MBeanService;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.struct.Entry;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.management.Attribute;
import javax.management.ObjectName;

public abstract class BaseService
implements MBeanService {
    protected Hashtable<String, String> defaultOptions = new Hashtable();
    protected String domain;
    protected JMXConnection conn;

    public BaseService() {
        this.init();
    }

    protected abstract void init();

    protected ObjectName createObjectName(Hashtable<String, String> table) {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.putAll(this.defaultOptions);
        if (table != null) {
            options.putAll(table);
        }
        ObjectName oname = null;
        try {
            oname = new ObjectName(this.domain, options);
        }
        catch (Exception ex) {
            Loggers.getLogger(this.getClass()).warn(ex.getMessage(), (Throwable)ex);
        }
        Loggers.getLogger(this.getClass()).debug("create an ObjectName : " + oname);
        return oname;
    }

    @Override
    public List<Entry<String, Object>> getMBeanAttrs(Hashtable<String, String> options, Collection<String> attributeNames) {
        ObjectName oname = this.createObjectName(null);
        List<Attribute> attrList = null;
        if (attributeNames != null && !attributeNames.isEmpty()) {
            attrList = this.conn.getAttributes(oname, attributeNames.toArray(new String[0])).asList();
        }
        if (attrList == null) {
            Loggers.getLogger(this.getClass()).warn("The attributeNames is not specified");
            return Collects.immutableList();
        }
        LinkedList<Entry<String, Object>> mbean = new LinkedList<Entry<String, Object>>();
        for (Attribute attr : attrList) {
            String attrName = attr.getName();
            Object attrValue = attr.getValue();
            mbean.add(new Entry<String, Object>(attrName, attrValue));
        }
        return mbean;
    }
}

