/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.resource;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.io.resource.AbstractLocatableResource;
import com.jn.langx.io.resource.DefaultResourceLoader;
import com.jn.langx.io.resource.Location;
import com.jn.langx.io.resource.Resource;
import com.jn.langx.io.resource.UrlResource;

public class Locations {
    public static Location parseLocation(String location) {
        Object resource = new DefaultResourceLoader().loadResource(location);
        if (resource == null) {
            return null;
        }
        if (resource instanceof AbstractLocatableResource) {
            return ((AbstractLocatableResource)resource).getLocation();
        }
        return null;
    }

    public static <V extends Resource> V newResource(String location) {
        return new DefaultResourceLoader().loadResource(location);
    }

    public static boolean isFileLocation(@NonNull Location location) {
        return "file:".equals(location.getPrefix());
    }

    public static boolean isClasspathLocation(@NonNull Location location) {
        return "classpath:".equals(location.getPrefix());
    }

    public static boolean isUrlLocation(@NonNull Location location) {
        Object resource = Locations.newResource(location.getLocation());
        if (resource == null) {
            return false;
        }
        return resource instanceof UrlResource;
    }

    public static boolean isJarLocation(Location location) {
        String l = location.getLocation();
        return l.startsWith("jar:");
    }

    public static boolean isJarFileLocation(Location location) {
        String l = location.getLocation();
        return l.startsWith("jar:file:///");
    }

    public static boolean isJarEntryLocation(Location location) {
        String l = location.getLocation();
        return l.startsWith("jar:file:///") && l.contains("!/") && !l.endsWith("!/");
    }

    public static String getRelativePath(Location root, Location location) {
        String resourceLocation;
        if (root == null && location == null) {
            throw new IllegalArgumentException("At least one of root and location cannot be empty");
        }
        String rootLocation = root == null ? "" : root.getLocation();
        String string = resourceLocation = location == null ? "" : location.getLocation();
        if (resourceLocation.startsWith(rootLocation)) {
            return resourceLocation.substring(rootLocation.length());
        }
        return null;
    }

    public static Location newLocation(Location root, String relativePath) {
        if (root == null) {
            return new Location(null, relativePath);
        }
        if (relativePath == null) {
            return root;
        }
        return new Location(root.getPrefix(), root.getPath() + root.getPathSeparator() + relativePath);
    }
}

