/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.resource;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.EmptyEvalutible;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;

public final class Location
implements Comparable<Location>,
EmptyEvalutible {
    @Nullable
    private String prefix;
    @NonNull
    private String path;
    private String pathSeparator;

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public Location(String prefix, String path, String pathSeparator) {
        this.path = path;
        this.prefix = Strings.getEmptyIfNull(prefix);
        this.pathSeparator = Strings.useValueIfBlank(pathSeparator, "/");
    }

    public Location(String prefix, String path) {
        this(prefix, path, null);
    }

    public String getPath() {
        return this.path;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocation() {
        return this.prefix + this.path;
    }

    @Override
    public int compareTo(Location o) {
        Preconditions.checkNotNull(o);
        return this.getLocation().compareTo(o.getLocation());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return location.getLocation().equals(this.getLocation());
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    public String toString() {
        return this.getLocation();
    }

    @Override
    public boolean isEmpty() {
        return Emptys.isEmpty(this.path);
    }

    @Override
    public boolean isNull() {
        return Emptys.isNull(this.prefix);
    }
}

