/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.resource;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.io.resource.AbstractResource;
import com.jn.langx.io.resource.Locatable;
import com.jn.langx.io.resource.Location;
import com.jn.langx.util.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ByteArrayResource
extends AbstractResource<byte[]>
implements Locatable {
    private final byte[] byteArray;
    private final String path;

    public String getDescription() {
        return this.path;
    }

    @Override
    public String getPrefix() {
        return "bytes:";
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Location getLocation() {
        return new Location(this.getPrefix(), this.getPath());
    }

    @Override
    public String getAbsolutePath() {
        return this.getPath();
    }

    @Override
    public byte[] getRealResource() {
        return this.byteArray;
    }

    public ByteArrayResource(byte[] byteArray) {
        this(byteArray, "resource loaded from byte array");
    }

    public ByteArrayResource(byte[] byteArray, @Nullable String description) {
        Preconditions.checkNotNull(byteArray, "Byte array must not be null");
        this.byteArray = byteArray;
        this.path = description != null ? description : "";
    }

    public final byte[] getByteArray() {
        return this.byteArray;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long contentLength() {
        return this.byteArray.length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.byteArray);
    }

    public String toString() {
        return "Byte array resource [" + this.path + "]";
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ByteArrayResource && Arrays.equals(((ByteArrayResource)other).byteArray, this.byteArray);
    }

    public int hashCode() {
        return byte[].class.hashCode() * 29 * this.byteArray.length;
    }
}

