/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.buffer;

import com.jn.langx.util.DataSize;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.buffer.Buffer;
import com.jn.langx.util.function.Consumer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;

public class BigByteBuffer
extends Buffer<BigByteBuffer> {
    private final List<ByteBuffer> segments = Collects.emptyArrayList();
    public static final int MIN_SEGMENT_SIZE = DataSize.kb(4L).toInt();
    private boolean readonly = false;
    private final int segmentSize;
    private final boolean direct;

    public BigByteBuffer() {
        this(MIN_SEGMENT_SIZE);
    }

    public BigByteBuffer(int segmentSize) {
        this(Long.MAX_VALUE, segmentSize);
    }

    public BigByteBuffer(byte[] bytes, long cap, int segmentSize) {
        this(cap, false, segmentSize);
        this.put(bytes);
    }

    public BigByteBuffer(long cap) {
        this(cap, false, MIN_SEGMENT_SIZE);
    }

    public BigByteBuffer(long cap, int segmentSize) {
        this(cap, false, segmentSize);
    }

    public BigByteBuffer(long cap, boolean direct, int segmentSize) {
        this(-1L, 0L, cap, cap, direct, segmentSize);
    }

    public BigByteBuffer(long mark, long pos, long lim, long cap, boolean direct, int segmentSize) {
        super(mark, pos, lim, cap);
        Preconditions.checkArgument(segmentSize >= MIN_SEGMENT_SIZE);
        this.direct = direct;
        this.segmentSize = segmentSize;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public BigByteBuffer clear() {
        super.clear();
        Collects.forEach(this.segments, new Consumer<ByteBuffer>(){

            @Override
            public void accept(ByteBuffer buffer) {
                buffer.clear();
            }
        });
        return this;
    }

    @Override
    public BigByteBuffer flip() {
        super.flip();
        Collects.forEach(this.segments, new Consumer<ByteBuffer>(){

            @Override
            public void accept(ByteBuffer buffer) {
                buffer.flip();
            }
        });
        return this;
    }

    @Override
    public BigByteBuffer rewind() {
        super.rewind();
        Collects.forEach(this.segments, new Consumer<ByteBuffer>(){

            @Override
            public void accept(ByteBuffer buffer) {
                buffer.rewind();
            }
        });
        return this;
    }

    private ByteBuffer newBuffer() {
        return this.direct ? ByteBuffer.allocateDirect(this.segmentSize) : ByteBuffer.allocate(this.segmentSize);
    }

    private int segmentIndex(long index) {
        return (int)(index / (long)this.segmentSize);
    }

    private ByteBuffer getSegmentForPut() {
        ByteBuffer segment;
        if (this.position() >= this.limit()) {
            throw new BufferOverflowException();
        }
        int segmentIndex = this.segmentIndex(this.nextPutIndex());
        if (segmentIndex > this.segments.size() - 1) {
            segment = this.newBuffer();
            this.segments.add(segment);
        } else {
            segment = this.segments.get(segmentIndex);
        }
        return segment;
    }

    private ByteBuffer getSegmentForGet() {
        if (this.position() >= this.limit()) {
            throw new BufferUnderflowException();
        }
        return this.segments.get(this.segmentIndex(this.nextGetIndex()));
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final Object array() {
        return null;
    }

    @Override
    public final long arrayOffset() {
        return 0L;
    }

    public BigByteBuffer put(byte b) {
        Preconditions.checkState(!this.readonly, "the byte buffer is readonly");
        this.getSegmentForPut().put(b);
        return this;
    }

    public BigByteBuffer put(byte[] bytes) {
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                this.put(bytes[i]);
            }
        }
        return this;
    }

    public BigByteBuffer put(long index, byte b) {
        Preconditions.checkState(!this.readonly, "the byte buffer is readonly");
        ByteBuffer segment = this.segments.get(this.segmentIndex(this.checkIndex(index)));
        segment.put((int)(index % (long)this.segmentSize), b);
        return this;
    }

    public byte get() {
        return this.getSegmentForGet().get();
    }

    public byte get(long index) {
        ByteBuffer segment = this.segments.get(this.segmentIndex(this.checkIndex(index)));
        return segment.get((int)(index % (long)this.segmentSize));
    }

    public ByteBuffer get(long index, int maxLength) {
        Preconditions.checkArgument(maxLength >= 0);
        if ((long)maxLength > this.limit() - index) {
            maxLength = (int)(this.limit() - index);
        }
        ByteBuffer ret = ByteBuffer.wrap(new byte[maxLength]);
        for (int l = maxLength; l > 0; --l) {
            ret.put(this.get(index++));
        }
        return ret;
    }
}

