/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.el.boundary;

import com.jn.langx.el.boundary.Boundary;
import com.jn.langx.el.operator.LogicOperatorType;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import java.util.List;

public class CommonBoundary
implements Boundary {
    private List<Predicate<String>> predicates = Collects.emptyArrayList();
    private LogicOperatorType logicOperatorType = LogicOperatorType.AND;

    public CommonBoundary() {
    }

    public CommonBoundary(LogicOperatorType logicOperatorType) {
        this.setLogicOperatorType(logicOperatorType);
    }

    public void setLogicOperatorType(LogicOperatorType logicOperatorType) {
        this.logicOperatorType = logicOperatorType;
    }

    @Override
    public boolean test(String value) {
        Preconditions.checkNotEmpty(this.predicates);
        Preconditions.checkNotNull(this.logicOperatorType);
        boolean ret = false;
        switch (this.logicOperatorType) {
            case AND: {
                ret = Functions.allPredicate(this.predicates).test(value);
                break;
            }
            case OR: {
                ret = Functions.anyPredicate(this.predicates).test(value);
                break;
            }
            default: {
                ret = Functions.nonePredicate(this.predicates).test(value);
            }
        }
        return ret;
    }

    public void addPredicate(Predicate<String> predicate) {
        if (predicate != null) {
            this.predicates.add(predicate);
        }
    }

    protected List<Predicate<String>> getPredicates() {
        return this.predicates;
    }
}

