/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.configuration.file.directoryfile;

import com.jn.langx.configuration.Configuration;
import com.jn.langx.configuration.ConfigurationSerializer;
import com.jn.langx.configuration.ConfigurationWriter;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.Files;
import com.jn.langx.util.io.file.filter.WriteableFileFilter;
import com.jn.langx.util.logging.Loggers;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;

public class DirectoryBasedFileConfigurationWriter<T extends Configuration>
implements ConfigurationWriter<T> {
    private String directory;
    private ConfigurationSerializer<T, String> configurationSerializer;
    private Supplier<String, String> filenameSupplier;
    private Charset encoding = Charsets.getCharset("utf-8");

    @Override
    public void write(T configuration) {
        BufferedOutputStream outputStream;
        block6: {
            Preconditions.checkNotNull(configuration);
            Preconditions.checkNotNull(this.directory);
            String configString = this.configurationSerializer.serialize(configuration);
            if (Strings.isEmpty(configString)) {
                return;
            }
            String filePath = this.getConfigurationFilePath(configuration.getId());
            outputStream = null;
            try {
                if (Files.makeFile(filePath)) {
                    outputStream = new BufferedOutputStream(new FileOutputStream(new File(filePath)));
                    IOs.write(configString, (OutputStream)outputStream, this.encoding);
                    break block6;
                }
                Logger logger = Loggers.getLogger(this.getClass());
                logger.warn("write configuration to file fail, file: {}, configuration: {}", (Object)filePath, configuration);
            }
            catch (IOException ex) {
                try {
                    throw Throwables.wrapAsRuntimeException(ex);
                }
                catch (Throwable throwable) {
                    IOs.close(outputStream);
                    throw throwable;
                }
            }
        }
        IOs.close(outputStream);
    }

    public void setEncoding(String encoding) {
        this.encoding = Charsets.getCharset(encoding);
    }

    public void setDirectory(String directory) {
        Preconditions.checkNotNull(directory);
        Preconditions.test(new WriteableFileFilter(), new File(directory));
        this.directory = directory;
    }

    public void setConfigurationSerializer(ConfigurationSerializer<T, String> configurationSerializer) {
        this.configurationSerializer = configurationSerializer;
    }

    public void setFilenameSupplier(Supplier<String, String> filenameSupplier) {
        this.filenameSupplier = filenameSupplier;
    }

    @Override
    public boolean isSupportsWrite() {
        return true;
    }

    @Override
    public boolean isSupportsRewrite() {
        return true;
    }

    @Override
    public void rewrite(T configuration) {
        this.remove(configuration.getId());
        this.write(configuration);
    }

    @Override
    public boolean isSupportsRemove() {
        return true;
    }

    @Override
    public void remove(String id) {
        String filePath = this.getConfigurationFilePath(id);
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
    }

    private String getConfigurationFilePath(String configurationId) {
        return this.directory + File.separator + this.filenameSupplier.get(configurationId);
    }
}

