/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.configuration.file.directoryfile;

import com.jn.langx.configuration.AbstractConfigurationRepository;
import com.jn.langx.configuration.Configuration;
import com.jn.langx.configuration.file.directoryfile.DirectoryBasedFileConfigurationLoader;
import com.jn.langx.configuration.file.directoryfile.DirectoryBasedFileConfigurationWriter;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.diff.MapDiffResult;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.io.file.Files;
import com.jn.langx.util.logging.Loggers;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;

public class DirectoryBasedFileConfigurationRepository<T extends Configuration>
extends AbstractConfigurationRepository<T, DirectoryBasedFileConfigurationLoader<T>, DirectoryBasedFileConfigurationWriter<T>> {
    private String directory;
    private Map<String, Long> lastModifiedTimeMap = Collects.emptyHashMap();

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public void init() throws InitializationException {
        if (!this.inited) {
            super.init();
            Preconditions.checkNotNull(this.loader, "the configuration load is null");
            Preconditions.checkTrue(Strings.isNotBlank(this.directory), "directory is null");
            Logger logger = Loggers.getLogger(this.getClass());
            if (!Files.exists(new File(this.directory))) {
                logger.warn("Can't find a directory : {}, will create it", (Object)new File(this.directory).getAbsoluteFile());
                Files.makeDirs(this.directory);
            }
            ((DirectoryBasedFileConfigurationLoader)this.loader).setDirectory(this.directory);
            if (this.writer == null) {
                logger.warn("The writer is not specified for the repository ({}), will disable write configuration to storage", (Object)this.getName());
            } else {
                ((DirectoryBasedFileConfigurationWriter)this.writer).setDirectory(this.directory);
            }
            if (this.reloadIntervalInSeconds > 1) {
                logger.info("The configuration refresh task is disabled for repository: {}", (Object)this.getName());
            }
            this.inited = true;
        }
    }

    @Override
    public void reload() {
        Map<String, Long> modifiedTimeMap = ((DirectoryBasedFileConfigurationLoader)this.loader).scanConfigurationFileModifiedTimes();
        try {
            MapDiffResult lastModifiedDiffResult = Collects.diff(this.lastModifiedTimeMap, modifiedTimeMap);
            Collects.forEach(lastModifiedDiffResult.getRemoves(), new Consumer2<String, Long>(){

                @Override
                public void accept(String id, Long lastModified) {
                    DirectoryBasedFileConfigurationRepository.this.removeById(id, false);
                }
            });
            Collects.forEach(lastModifiedDiffResult.getUpdates(), new Consumer2<String, Long>(){

                @Override
                public void accept(String id, Long lastModified) {
                    Object configurationInStorage = ((DirectoryBasedFileConfigurationLoader)DirectoryBasedFileConfigurationRepository.this.loader).load(id);
                    Object configurationInCache = DirectoryBasedFileConfigurationRepository.this.getById(id);
                    if (configurationInCache == null) {
                        DirectoryBasedFileConfigurationRepository.this.add(configurationInStorage, false);
                    } else if (!configurationInCache.equals(configurationInStorage)) {
                        DirectoryBasedFileConfigurationRepository.this.update(configurationInStorage, false);
                    }
                }
            });
            Collects.forEach(lastModifiedDiffResult.getAdds(), new Consumer2<String, Long>(){

                @Override
                public void accept(String id, Long lastModified) {
                    Object configurationInStorage = ((DirectoryBasedFileConfigurationLoader)DirectoryBasedFileConfigurationRepository.this.loader).load(id);
                    Object configurationInCache = DirectoryBasedFileConfigurationRepository.this.getById(id);
                    if (configurationInCache == null) {
                        DirectoryBasedFileConfigurationRepository.this.add(configurationInStorage, false);
                    } else if (!configurationInCache.equals(configurationInStorage)) {
                        DirectoryBasedFileConfigurationRepository.this.update(configurationInStorage, false);
                    }
                }
            });
        }
        finally {
            this.lastModifiedTimeMap = modifiedTimeMap;
        }
    }
}

