/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.commandline.launcher;

import com.jn.langx.commandline.CommandLine;
import com.jn.langx.commandline.ProcessAdapter;
import com.jn.langx.commandline.launcher.Java13CommandLauncher;
import com.jn.langx.util.Strings;
import com.jn.langx.util.io.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;

public class VmsCommandLauncher
extends Java13CommandLauncher {
    @Override
    public ProcessAdapter exec(CommandLine cmd, Map<String, String> env) throws IOException {
        CommandLine vmsCmd = new CommandLine(this.createCommandFile(cmd, env).getPath());
        return super.exec(vmsCmd, (Map)env);
    }

    @Override
    public ProcessAdapter exec(CommandLine cmd, Map<String, String> env, File workingDir) throws IOException {
        CommandLine vmsCmd = new CommandLine(this.createCommandFile(cmd, env).getPath());
        return super.exec(vmsCmd, (Map)env, workingDir);
    }

    @Override
    public boolean isFailure(int exitValue) {
        return exitValue % 2 == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createCommandFile(CommandLine cmd, Map<String, String> env) throws IOException {
        File script = File.createTempFile("EXEC", ".TMP");
        script.deleteOnExit();
        PrintWriter out = null;
        try {
            String[] args;
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(script.getAbsolutePath(), true), Charsets.UTF_8));
            if (env != null) {
                Set<Map.Entry<String, String>> entries = env.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    out.print("$ ");
                    out.print(entry.getKey());
                    out.print(" == ");
                    out.println('\"');
                    String value = entry.getValue();
                    if (value.indexOf(34) > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < value.length(); ++i) {
                            char c = value.charAt(i);
                            if (c == '\"') {
                                sb.append('\"');
                            }
                            sb.append(c);
                        }
                        value = sb.toString();
                    }
                    out.print(value);
                    out.println('\"');
                }
            }
            String command = cmd.getExecutable();
            if (cmd.isFile()) {
                out.print("$ @");
                String[] parts = Strings.split(command, "/");
                out.print(parts[0]);
                out.print(":[");
                out.print(parts[1]);
                int lastPart = parts.length - 1;
                for (int i = 2; i < lastPart; ++i) {
                    out.print(".");
                    out.print(parts[i]);
                }
                out.print("]");
                out.print(parts[lastPart]);
            } else {
                out.print("$ ");
                out.print(command);
            }
            for (String arg : args = cmd.getArguments()) {
                out.println(" -");
                out.print(arg);
            }
            out.println();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return script;
    }
}

