/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.codec.hex;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.asn1.bytestring.ByteStringBuffer;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.io.LineDelimiter;
import com.jn.langx.util.io.unicode.Utf8s;
import java.text.ParseException;

public class Hexs {
    public static boolean isHex(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    @NonNull
    public static String toHex(byte b) {
        StringBuilder buffer = new StringBuilder(2);
        Hexs.toHex(b, buffer);
        return buffer.toString();
    }

    public static void toHex(byte b, @NonNull StringBuilder buffer) {
        switch (b & 0xF0) {
            case 0: {
                buffer.append('0');
                break;
            }
            case 16: {
                buffer.append('1');
                break;
            }
            case 32: {
                buffer.append('2');
                break;
            }
            case 48: {
                buffer.append('3');
                break;
            }
            case 64: {
                buffer.append('4');
                break;
            }
            case 80: {
                buffer.append('5');
                break;
            }
            case 96: {
                buffer.append('6');
                break;
            }
            case 112: {
                buffer.append('7');
                break;
            }
            case 128: {
                buffer.append('8');
                break;
            }
            case 144: {
                buffer.append('9');
                break;
            }
            case 160: {
                buffer.append('a');
                break;
            }
            case 176: {
                buffer.append('b');
                break;
            }
            case 192: {
                buffer.append('c');
                break;
            }
            case 208: {
                buffer.append('d');
                break;
            }
            case 224: {
                buffer.append('e');
                break;
            }
            case 240: {
                buffer.append('f');
            }
        }
        switch (b & 0xF) {
            case 0: {
                buffer.append('0');
                break;
            }
            case 1: {
                buffer.append('1');
                break;
            }
            case 2: {
                buffer.append('2');
                break;
            }
            case 3: {
                buffer.append('3');
                break;
            }
            case 4: {
                buffer.append('4');
                break;
            }
            case 5: {
                buffer.append('5');
                break;
            }
            case 6: {
                buffer.append('6');
                break;
            }
            case 7: {
                buffer.append('7');
                break;
            }
            case 8: {
                buffer.append('8');
                break;
            }
            case 9: {
                buffer.append('9');
                break;
            }
            case 10: {
                buffer.append('a');
                break;
            }
            case 11: {
                buffer.append('b');
                break;
            }
            case 12: {
                buffer.append('c');
                break;
            }
            case 13: {
                buffer.append('d');
                break;
            }
            case 14: {
                buffer.append('e');
                break;
            }
            case 15: {
                buffer.append('f');
            }
        }
    }

    public static void toHex(byte b, @NonNull ByteStringBuffer buffer) {
        switch (b & 0xF0) {
            case 0: {
                buffer.append((byte)48);
                break;
            }
            case 16: {
                buffer.append((byte)49);
                break;
            }
            case 32: {
                buffer.append((byte)50);
                break;
            }
            case 48: {
                buffer.append((byte)51);
                break;
            }
            case 64: {
                buffer.append((byte)52);
                break;
            }
            case 80: {
                buffer.append((byte)53);
                break;
            }
            case 96: {
                buffer.append((byte)54);
                break;
            }
            case 112: {
                buffer.append((byte)55);
                break;
            }
            case 128: {
                buffer.append((byte)56);
                break;
            }
            case 144: {
                buffer.append((byte)57);
                break;
            }
            case 160: {
                buffer.append((byte)97);
                break;
            }
            case 176: {
                buffer.append((byte)98);
                break;
            }
            case 192: {
                buffer.append((byte)99);
                break;
            }
            case 208: {
                buffer.append((byte)100);
                break;
            }
            case 224: {
                buffer.append((byte)101);
                break;
            }
            case 240: {
                buffer.append((byte)102);
            }
        }
        switch (b & 0xF) {
            case 0: {
                buffer.append((byte)48);
                break;
            }
            case 1: {
                buffer.append((byte)49);
                break;
            }
            case 2: {
                buffer.append((byte)50);
                break;
            }
            case 3: {
                buffer.append((byte)51);
                break;
            }
            case 4: {
                buffer.append((byte)52);
                break;
            }
            case 5: {
                buffer.append((byte)53);
                break;
            }
            case 6: {
                buffer.append((byte)54);
                break;
            }
            case 7: {
                buffer.append((byte)55);
                break;
            }
            case 8: {
                buffer.append((byte)56);
                break;
            }
            case 9: {
                buffer.append((byte)57);
                break;
            }
            case 10: {
                buffer.append((byte)97);
                break;
            }
            case 11: {
                buffer.append((byte)98);
                break;
            }
            case 12: {
                buffer.append((byte)99);
                break;
            }
            case 13: {
                buffer.append((byte)100);
                break;
            }
            case 14: {
                buffer.append((byte)101);
                break;
            }
            case 15: {
                buffer.append((byte)102);
            }
        }
    }

    @NonNull
    public static String toHex(@NonNull byte[] b) {
        Preconditions.checkNotNull(b);
        StringBuilder buffer = new StringBuilder(2 * b.length);
        Hexs.toHex(b, buffer);
        return buffer.toString();
    }

    public static void toHex(@NonNull byte[] b, @NonNull StringBuilder buffer) {
        Hexs.toHex(b, null, buffer);
    }

    public static void toHex(@NonNull byte[] b, @Nullable String delimiter, @NonNull StringBuilder buffer) {
        boolean first = true;
        for (byte bt : b) {
            if (first) {
                first = false;
            } else if (delimiter != null) {
                buffer.append(delimiter);
            }
            Hexs.toHex(bt, buffer);
        }
    }

    @NonNull
    public static String toHexPlusASCII(@NonNull byte[] array, int indent) {
        StringBuilder buffer = new StringBuilder();
        Hexs.toHexPlusASCII(array, indent, buffer);
        return buffer.toString();
    }

    public static void toHexPlusASCII(@Nullable byte[] array, int indent, @NonNull StringBuilder buffer) {
        if (array == null || array.length == 0) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        int pos = 0;
        int startPos = 0;
        while (pos < array.length) {
            int i;
            Hexs.toHex(array[pos++], buffer);
            buffer.append(' ');
            if (pos % 16 != 0) continue;
            buffer.append("  ");
            for (i = startPos; i < pos; ++i) {
                if (array[i] < 32 || array[i] > 126) {
                    buffer.append(' ');
                    continue;
                }
                buffer.append((char)array[i]);
            }
            buffer.append(LineDelimiter.EOL);
            startPos = pos;
            if (pos >= array.length) continue;
            for (i = 0; i < indent; ++i) {
                buffer.append(' ');
            }
        }
        if (array.length % 16 != 0) {
            int i;
            int missingBytes = 16 - array.length % 16;
            for (i = 0; i < missingBytes; ++i) {
                buffer.append("   ");
            }
            buffer.append("  ");
            for (i = startPos; i < array.length; ++i) {
                if (array[i] < 32 || array[i] > 126) {
                    buffer.append(' ');
                    continue;
                }
                buffer.append((char)array[i]);
            }
            buffer.append(LineDelimiter.EOL);
        }
    }

    @NonNull
    public static byte[] fromHex(@NonNull String hexString) throws ParseException {
        if (hexString.length() % 2 != 0) {
            String err = "Unable to decode the provided hexadecimal string to a byte array because the provided string had a length of {} characters, but it is only possible to process strings with an even number of characters.";
            err = StringTemplates.formatWithPlaceholder(err, hexString.length());
            throw new ParseException(err, hexString.length());
        }
        byte[] decodedBytes = new byte[hexString.length() / 2];
        int i = 0;
        int j = 0;
        while (i < decodedBytes.length) {
            switch (hexString.charAt(j)) {
                case '0': {
                    break;
                }
                case '1': {
                    decodedBytes[i] = 16;
                    break;
                }
                case '2': {
                    decodedBytes[i] = 32;
                    break;
                }
                case '3': {
                    decodedBytes[i] = 48;
                    break;
                }
                case '4': {
                    decodedBytes[i] = 64;
                    break;
                }
                case '5': {
                    decodedBytes[i] = 80;
                    break;
                }
                case '6': {
                    decodedBytes[i] = 96;
                    break;
                }
                case '7': {
                    decodedBytes[i] = 112;
                    break;
                }
                case '8': {
                    decodedBytes[i] = -128;
                    break;
                }
                case '9': {
                    decodedBytes[i] = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    decodedBytes[i] = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    decodedBytes[i] = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    decodedBytes[i] = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    decodedBytes[i] = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    decodedBytes[i] = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    decodedBytes[i] = -16;
                    break;
                }
                default: {
                    String err = "Unable to decode the provided hexadecimal string to a byte array because the provided string had a non-hex character at index {}.";
                    err = StringTemplates.formatWithPlaceholder(err, j);
                    throw new ParseException(err, j);
                }
            }
            switch (hexString.charAt(j + 1)) {
                case '0': {
                    break;
                }
                case '1': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 1);
                    break;
                }
                case '2': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 2);
                    break;
                }
                case '3': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 3);
                    break;
                }
                case '4': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 4);
                    break;
                }
                case '5': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 5);
                    break;
                }
                case '6': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 6);
                    break;
                }
                case '7': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 7);
                    break;
                }
                case '8': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 8);
                    break;
                }
                case '9': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xF);
                    break;
                }
                default: {
                    String err = "Unable to decode the provided hexadecimal string to a byte array because the provided string had a non-hex character at index {}.";
                    err = StringTemplates.formatWithPlaceholder(err, j + 1);
                    throw new ParseException(err, j + 1);
                }
            }
            ++i;
            j += 2;
        }
        return decodedBytes;
    }

    public static void hexEncode(char c, @NonNull StringBuilder buffer) {
        byte[] charBytes = c <= '\u007f' ? new byte[]{(byte)(c & 0x7F)} : Utf8s.getBytes(String.valueOf(c));
        for (byte b : charBytes) {
            buffer.append('\\');
            Hexs.toHex(b, buffer);
        }
    }

    public static void hexEncode(int codePoint, @NonNull StringBuilder buffer) {
        byte[] charBytes;
        for (byte b : charBytes = Utf8s.getBytes(new String(new int[]{codePoint}, 0, 1))) {
            buffer.append('\\');
            Hexs.toHex(b, buffer);
        }
    }
}

