/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.codec.hex;

import com.jn.langx.codec.BinaryCodec;
import com.jn.langx.codec.CodecException;
import com.jn.langx.codec.hex.Hex;
import com.jn.langx.util.io.Charsets;
import java.nio.charset.Charset;

public class HexCodec
implements BinaryCodec {
    private final Charset charset;

    public HexCodec() {
        this.charset = Charsets.UTF_8;
    }

    public HexCodec(Charset charset) {
        this.charset = charset;
    }

    public HexCodec(String charsetName) {
        this(Charset.forName(charsetName));
    }

    @Override
    public byte[] decode(byte[] array) throws CodecException {
        return Hex.decodeHex(new String(array, this.getCharset()).toCharArray());
    }

    @Override
    public byte[] encode(byte[] array) {
        return Hex.encodeHexString(array).getBytes(this.getCharset());
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getCharsetName() {
        return this.charset.name();
    }

    public String toString() {
        return super.toString() + "[charsetName=" + this.charset + "]";
    }
}

