/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.asn1.OID;
import com.jn.langx.asn1.bytestring.ByteStringBuffer;
import com.jn.langx.asn1.spec.ASN1Element;
import com.jn.langx.asn1.spec.ASN1Exception;
import com.jn.langx.asn1.spec.ASN1Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ASN1ObjectIdentifier
extends ASN1Element {
    private static final long serialVersionUID = -777778295086222273L;
    @NonNull
    private final OID oid;

    public ASN1ObjectIdentifier(@NonNull OID oid) throws ASN1Exception {
        this(6, oid);
    }

    public ASN1ObjectIdentifier(byte type, @NonNull OID oid) throws ASN1Exception {
        this(type, oid, ASN1ObjectIdentifier.encodeValue(oid));
    }

    public ASN1ObjectIdentifier(@NonNull String oidString) throws ASN1Exception {
        this(6, oidString);
    }

    public ASN1ObjectIdentifier(byte type, @NonNull String oidString) throws ASN1Exception {
        this(type, new OID(oidString));
    }

    private ASN1ObjectIdentifier(byte type, @NonNull OID oid, @NonNull byte[] encodedValue) {
        super(type, encodedValue);
        this.oid = oid;
    }

    @NonNull
    private static byte[] encodeValue(@NonNull OID oid) throws ASN1Exception {
        if (!oid.isValidNumericOID()) {
            throw new ASN1Exception(ASN1Messages.ERR_OID_ENCODE_NOT_NUMERIC.get());
        }
        List<Integer> components = oid.getComponents();
        if (components.size() < 2) {
            throw new ASN1Exception(ASN1Messages.ERR_OID_ENCODE_NOT_ENOUGH_COMPONENTS.get(oid.toString()));
        }
        Iterator<Integer> componentIterator = components.iterator();
        int firstComponent = componentIterator.next();
        if (firstComponent < 0 || firstComponent > 2) {
            throw new ASN1Exception(ASN1Messages.ERR_OID_ENCODE_INVALID_FIRST_COMPONENT.get(oid.toString(), firstComponent));
        }
        int secondComponent = componentIterator.next();
        if (secondComponent < 0 || firstComponent != 2 && secondComponent > 39) {
            throw new ASN1Exception(ASN1Messages.ERR_OID_ENCODE_INVALID_SECOND_COMPONENT.get(oid.toString(), firstComponent, secondComponent));
        }
        ByteStringBuffer buffer = new ByteStringBuffer();
        int mergedFirstComponents = 40 * firstComponent + secondComponent;
        ASN1ObjectIdentifier.encodeComponent(mergedFirstComponents, buffer);
        while (componentIterator.hasNext()) {
            ASN1ObjectIdentifier.encodeComponent(componentIterator.next(), buffer);
        }
        return buffer.toByteArray();
    }

    private static void encodeComponent(int c, @NonNull ByteStringBuffer b) {
        int finalByte = c & 0x7F;
        if (finalByte == c) {
            b.append((byte)finalByte);
        } else if ((c & 0x3FFF) == c) {
            b.append((byte)(0x80 | c >> 7 & 0x7F));
            b.append((byte)finalByte);
        } else if ((c & 0xFFFFF) == c) {
            b.append((byte)(0x80 | c >> 14 & 0x7F));
            b.append((byte)(0x80 | c >> 7 & 0x7F));
            b.append((byte)finalByte);
        } else if ((c & 0xFFFFFF) == c) {
            b.append((byte)(0x80 | c >> 21 & 0x7F));
            b.append((byte)(0x80 | c >> 14 & 0x7F));
            b.append((byte)(0x80 | c >> 7 & 0x7F));
            b.append((byte)finalByte);
        } else {
            b.append((byte)(0x80 | c >> 28 & 0x7F));
            b.append((byte)(0x80 | c >> 21 & 0x7F));
            b.append((byte)(0x80 | c >> 14 & 0x7F));
            b.append((byte)(0x80 | c >> 7 & 0x7F));
            b.append((byte)finalByte);
        }
    }

    @NonNull
    public OID getOID() {
        return this.oid;
    }

    @NonNull
    public static ASN1ObjectIdentifier decodeAsObjectIdentifier(@NonNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            byte[] elementValue = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, elementValue, 0, length);
            OID oid = ASN1ObjectIdentifier.decodeValue(elementValue);
            return new ASN1ObjectIdentifier(elementBytes[0], oid, elementValue);
        }
        catch (ASN1Exception ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NonNull
    public static ASN1ObjectIdentifier decodeAsObjectIdentifier(@NonNull ASN1Element element) throws ASN1Exception {
        OID oid = ASN1ObjectIdentifier.decodeValue(element.getValue());
        return new ASN1ObjectIdentifier(element.getType(), oid, element.getValue());
    }

    @NonNull
    private static OID decodeValue(@NonNull byte[] elementValue) throws ASN1Exception {
        if (elementValue.length == 0) {
            throw new ASN1Exception(ASN1Messages.ERR_OID_DECODE_EMPTY_VALUE.get());
        }
        byte lastByte = elementValue[elementValue.length - 1];
        if ((lastByte & 0x80) == 128) {
            throw new ASN1Exception(ASN1Messages.ERR_OID_DECODE_INCOMPLETE_VALUE.get());
        }
        int currentComponent = 0;
        ArrayList<Integer> components = new ArrayList<Integer>(elementValue.length);
        for (byte b : elementValue) {
            currentComponent <<= 7;
            currentComponent |= b & 0x7F;
            if ((b & 0x80) != 0) continue;
            if (components.isEmpty()) {
                if (currentComponent < 40) {
                    components.add(0);
                    components.add(currentComponent);
                } else if (currentComponent < 80) {
                    components.add(1);
                    components.add(currentComponent - 40);
                } else {
                    components.add(2);
                    components.add(currentComponent - 80);
                }
            } else {
                components.add(currentComponent);
            }
            currentComponent = 0;
        }
        return new OID(components);
    }

    @Override
    public void toString(@NonNull StringBuilder buffer) {
        buffer.append(this.oid.toString());
    }
}

