/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.asn1.spec.ASN1Element;
import com.jn.langx.asn1.spec.ASN1Exception;
import com.jn.langx.asn1.spec.ASN1Messages;
import com.jn.langx.util.io.unicode.Utf8s;

public final class ASN1NumericString
extends ASN1Element {
    private static final long serialVersionUID = -3972798266250943461L;
    @NonNull
    private final String stringValue;

    public ASN1NumericString(@Nullable String stringValue) throws ASN1Exception {
        this(18, stringValue);
    }

    public ASN1NumericString(byte type, @Nullable String stringValue) throws ASN1Exception {
        this(type, stringValue, Utf8s.getBytes(stringValue));
    }

    private ASN1NumericString(byte type, @Nullable String stringValue, @NonNull byte[] encodedValue) throws ASN1Exception {
        super(type, encodedValue);
        if (stringValue == null) {
            this.stringValue = "";
        } else {
            this.stringValue = stringValue;
            for (char c : stringValue.toCharArray()) {
                if (c >= '0' && c <= '9' || c == ' ') continue;
                throw new ASN1Exception(ASN1Messages.ERR_NUMERIC_STRING_DECODE_VALUE_NOT_NUMERIC.get());
            }
        }
    }

    @NonNull
    public String stringValue() {
        return this.stringValue;
    }

    @NonNull
    public static ASN1NumericString decodeAsNumericString(@NonNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            byte[] elementValue = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, elementValue, 0, length);
            return new ASN1NumericString(elementBytes[0], Utf8s.toString(elementValue), elementValue);
        }
        catch (ASN1Exception ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NonNull
    public static ASN1NumericString decodeAsNumericString(@NonNull ASN1Element element) throws ASN1Exception {
        byte[] elementValue = element.getValue();
        return new ASN1NumericString(element.getType(), Utf8s.toString(elementValue), elementValue);
    }

    @Override
    public void toString(@NonNull StringBuilder buffer) {
        buffer.append(this.stringValue);
    }
}

