/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1.spec;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.asn1.spec.ASN1Element;
import com.jn.langx.asn1.spec.ASN1Exception;
import com.jn.langx.asn1.spec.ASN1Messages;
import java.math.BigInteger;

public final class ASN1BigInteger
extends ASN1Element {
    private static final long serialVersionUID = 2631806934961821260L;
    @NonNull
    private final BigInteger value;

    public ASN1BigInteger(@NonNull BigInteger value) {
        this(2, value);
    }

    public ASN1BigInteger(byte type, @NonNull BigInteger value) {
        super(type, value.toByteArray());
        this.value = value;
    }

    private ASN1BigInteger(byte type, @NonNull BigInteger bigIntegerValue, @NonNull byte[] berValue) {
        super(type, berValue);
        this.value = bigIntegerValue;
    }

    public ASN1BigInteger(long value) {
        this(2, BigInteger.valueOf(value));
    }

    public ASN1BigInteger(byte type, long value) {
        this(type, BigInteger.valueOf(value));
    }

    @NonNull
    public BigInteger getBigIntegerValue() {
        return this.value;
    }

    @NonNull
    public static ASN1BigInteger decodeAsBigInteger(@NonNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            if (length == 0) {
                throw new ASN1Exception(ASN1Messages.ERR_BIG_INTEGER_DECODE_EMPTY_VALUE.get());
            }
            byte[] elementValue = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, elementValue, 0, length);
            BigInteger bigIntegerValue = new BigInteger(elementValue);
            return new ASN1BigInteger(elementBytes[0], bigIntegerValue, elementValue);
        }
        catch (ASN1Exception ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NonNull
    public static ASN1BigInteger decodeAsBigInteger(@NonNull ASN1Element element) throws ASN1Exception {
        byte[] value = element.getValue();
        if (value.length == 0) {
            throw new ASN1Exception(ASN1Messages.ERR_BIG_INTEGER_DECODE_EMPTY_VALUE.get());
        }
        return new ASN1BigInteger(element.getType(), new BigInteger(value), value);
    }

    @Override
    public void toString(@NonNull StringBuilder buffer) {
        buffer.append(this.value);
    }
}

