/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.asn1;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public final class OID
implements Serializable,
Comparable<OID> {
    private static final long serialVersionUID = -4542498394670806081L;
    @Nullable
    private final List<Integer> components;
    @NonNull
    private final String oidString;

    public OID(@Nullable String oidString) {
        this.oidString = oidString == null ? "" : oidString;
        this.components = OID.parseComponents(oidString);
    }

    public OID(int ... components) {
        this(OID.toList(components));
    }

    public OID(@Nullable List<Integer> components) {
        if (components == null || components.isEmpty()) {
            this.components = null;
            this.oidString = "";
        } else {
            this.components = Collections.unmodifiableList(new ArrayList<Integer>(components));
            StringBuilder buffer = new StringBuilder();
            for (Integer i : components) {
                if (buffer.length() > 0) {
                    buffer.append('.');
                }
                buffer.append(i);
            }
            this.oidString = buffer.toString();
        }
    }

    public OID(@NonNull OID parentOID, int childComponent) throws ParseException {
        if (parentOID.components == null) {
            String err = "Unable to create an OID that is a child of OID {} because the provided is not a valid numeric OID.";
            err = StringTemplates.formatWithPlaceholder(err, String.valueOf(parentOID));
            throw new ParseException(err, 0);
        }
        this.components = new ArrayList<Integer>(parentOID.components.size() + 1);
        this.components.addAll(parentOID.components);
        this.components.add(childComponent);
        this.oidString = parentOID.oidString + '.' + childComponent;
    }

    private OID(@NonNull String oidString, @NonNull List<Integer> components) {
        this.oidString = oidString;
        this.components = Collections.unmodifiableList(components);
    }

    @Nullable
    private static List<Integer> toList(int ... components) {
        if (components == null) {
            return null;
        }
        ArrayList<Integer> compList = new ArrayList<Integer>(components.length);
        for (int i : components) {
            compList.add(i);
        }
        return compList;
    }

    @Nullable
    public static List<Integer> parseComponents(@Nullable String oidString) {
        if (oidString == null || oidString.isEmpty() || oidString.startsWith(".") || oidString.endsWith(".") || oidString.indexOf("..") > 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(oidString, ".");
        ArrayList<Integer> compList = new ArrayList<Integer>(10);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                compList.add(Integer.parseInt(token));
            }
            catch (Exception e) {
                return null;
            }
        }
        return Collections.unmodifiableList(compList);
    }

    @NonNull
    public static OID parseNumericOID(@Nullable String oidString, boolean strict) throws ParseException {
        if (oidString == null || oidString.isEmpty()) {
            String err = "Unable to parse the provided string as an object identifier because it is empty.";
            throw new ParseException(err, 0);
        }
        int componentStartPos = 0;
        ArrayList<Integer> components = new ArrayList<Integer>(oidString.length());
        StringBuilder buffer = new StringBuilder(oidString.length());
        block12: for (int i = 0; i < oidString.length(); ++i) {
            char c = oidString.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    buffer.append(c);
                    continue block12;
                }
                case '.': {
                    if (buffer.length() == 0) {
                        if (i == 0) {
                            String err = "Unable to parse {} as an object identifier because it starts with a period.";
                            err = StringTemplates.formatWithPlaceholder(err, oidString);
                            throw new ParseException(err, i);
                        }
                        String err = "Unable to parse {} as an object identifier because it contains consecutive periods at position {}.";
                        err = StringTemplates.formatWithPlaceholder(err, oidString, i);
                        throw new ParseException(err, i);
                    }
                    if (buffer.length() > 1 && buffer.charAt(0) == '0') {
                        String err = "Unable to parse {} as an object identifier because it contains component {} that starts with a leading zero.";
                        err = StringTemplates.formatWithPlaceholder(err, oidString, buffer.toString());
                        throw new ParseException(err, componentStartPos);
                    }
                    try {
                        components.add(Integer.parseInt(buffer.toString()));
                    }
                    catch (Exception e) {
                        String err = "Unable to parse {} as an object identifier because component {} is out of range for a 32-bit integer.";
                        err = StringTemplates.formatWithPlaceholder(err, oidString, buffer.toString(), componentStartPos);
                        throw new ParseException(err, componentStartPos);
                    }
                    buffer.setLength(0);
                    componentStartPos = i + 1;
                    continue block12;
                }
                default: {
                    String err = "Unable to parse {} as an object identifier because it contains illegal character {} at position {}.";
                    err = StringTemplates.formatWithPlaceholder(err, oidString, Character.valueOf(c), i);
                    throw new ParseException(err, i);
                }
            }
        }
        if (buffer.length() == 0) {
            String err = "Unable to parse {} as an object identifier because it ends with a period.";
            err = StringTemplates.formatWithPlaceholder(err, oidString);
            throw new ParseException(err, oidString.length() - 1);
        }
        if (buffer.length() > 1 && buffer.charAt(0) == '0') {
            String err = "Unable to parse {} as an object identifier because it contains component {} that starts with a leading zero.";
            err = StringTemplates.formatWithPlaceholder(err, oidString, buffer.toString());
            throw new ParseException(err, componentStartPos);
        }
        try {
            components.add(Integer.parseInt(buffer.toString()));
        }
        catch (Exception e) {
            String err = "Unable to parse {} as an object identifier because component {} is out of range for a 32-bit integer.";
            err = StringTemplates.formatWithPlaceholder(err, oidString, buffer.toString(), componentStartPos);
            throw new ParseException(err, componentStartPos);
        }
        if (strict) {
            if (components.size() < 2) {
                String err = "Unable to parse {} as a valid object identifier because it only contains a single component.  Valid OIDs must have at least two components.";
                err = StringTemplates.formatWithPlaceholder(err, oidString);
                throw new ParseException(err, 0);
            }
            int firstComponent = (Integer)components.get(0);
            int secondComponent = (Integer)components.get(1);
            switch (firstComponent) {
                case 0: 
                case 1: {
                    if (secondComponent <= 39) break;
                    String err = "Unable to parse {} as a valid object identifier because the second component value of {} is out of range.  If the first component is {}, then the second component must not be greater than 39.";
                    err = StringTemplates.formatWithPlaceholder(err, oidString, secondComponent, firstComponent);
                    throw new ParseException(err, 0);
                }
                case 2: {
                    break;
                }
                default: {
                    String err = "Unable to parse '{}' as a valid object identifier because the first component value of {} is not valid.  The first component of a numeric OID can only be zero, one, or two.";
                    err = StringTemplates.formatWithPlaceholder(err, oidString, firstComponent);
                    throw new ParseException(err, 0);
                }
            }
        }
        return new OID(oidString, components);
    }

    public static boolean isValidNumericOID(@Nullable String s) {
        return new OID(s).isValidNumericOID();
    }

    public boolean isValidNumericOID() {
        return this.components != null;
    }

    public static boolean isStrictlyValidNumericOID(@Nullable String s) {
        return new OID(s).isStrictlyValidNumericOID();
    }

    public boolean isStrictlyValidNumericOID() {
        if (this.components == null || this.components.size() < 2) {
            return false;
        }
        int firstComponent = this.components.get(0);
        int secondComponent = this.components.get(1);
        switch (firstComponent) {
            case 0: 
            case 1: {
                return secondComponent <= 39;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public List<Integer> getComponents() {
        return this.components;
    }

    @Nullable
    public OID getParent() throws ParseException {
        if (this.components == null) {
            String err = "Unable to retrieve the parent for OID {} because it is not a valid numeric OID.";
            err = StringTemplates.formatWithPlaceholder(err, this.oidString);
            throw new ParseException(err, 0);
        }
        if (this.components.size() <= 1) {
            return null;
        }
        ArrayList<Integer> childComponents = new ArrayList<Integer>(this.components);
        childComponents.remove(this.components.size() - 1);
        return new OID(childComponents);
    }

    public boolean isAncestorOf(@NonNull OID oid) throws ParseException {
        if (this.components == null) {
            String err = "Unable to determine whether OID '{}' is an ancestor of OID '{}' because the former is not a valid numeric OID.";
            err = StringTemplates.formatWithPlaceholder(err, this.oidString, oid.oidString);
            throw new ParseException(err, 0);
        }
        if (oid.components == null) {
            String err = "Unable to determine whether OID '{}' is an ancestor of OID '{}' because the latter is not a valid numeric OID.";
            err = StringTemplates.formatWithPlaceholder(err, oid.oidString, oid.oidString);
            throw new ParseException(err, 0);
        }
        if (oid.components.size() <= this.components.size()) {
            return false;
        }
        for (int i = 0; i < this.components.size(); ++i) {
            if (this.components.get(i).equals(oid.components.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isDescendantOf(@NonNull OID oid) throws ParseException {
        if (this.components == null) {
            String err = "Unable to determine whether OID '{}' is a descendant of OID '{}' because the former is not a valid numeric OID.";
            err = StringTemplates.formatWithPlaceholder(err, this.oidString, oid.oidString);
            throw new ParseException(err, 0);
        }
        if (oid.components == null) {
            String err = "Unable to determine whether OID '{}' is a descendant of OID '{}' because the latter is not a valid numeric OID.";
            err = StringTemplates.formatWithPlaceholder(err, oid.oidString, oid.oidString);
            throw new ParseException(err, 0);
        }
        if (this.components.size() <= oid.components.size()) {
            return false;
        }
        for (int i = 0; i < oid.components.size(); ++i) {
            if (this.components.get(i).equals(oid.components.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.components == null) {
            return this.oidString.hashCode();
        }
        int hashCode = 0;
        for (int i : this.components) {
            hashCode += i;
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof OID) {
            OID oid = (OID)o;
            if (this.components == null) {
                return this.oidString.equals(oid.oidString);
            }
            return this.components.equals(oid.components);
        }
        return false;
    }

    @Override
    public int compareTo(@NonNull OID oid) {
        if (this.components == null) {
            if (oid.components == null) {
                return this.oidString.compareTo(oid.oidString);
            }
            return 1;
        }
        if (oid.components == null) {
            return -1;
        }
        for (int i = 0; i < Math.min(this.components.size(), oid.components.size()); ++i) {
            int thatValue;
            int thisValue = this.components.get(i);
            if (thisValue < (thatValue = oid.components.get(i).intValue())) {
                return -1;
            }
            if (thisValue <= thatValue) continue;
            return 1;
        }
        if (this.components.size() < oid.components.size()) {
            return -1;
        }
        if (this.components.size() > oid.components.size()) {
            return 1;
        }
        return 0;
    }

    @NonNull
    public String toString() {
        return this.oidString;
    }
}

