/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.node;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.jn.easyjson.core.JsonTreeNode;
import com.jn.easyjson.core.node.JsonArrayNode;
import com.jn.easyjson.core.node.JsonNullNode;
import com.jn.easyjson.core.node.JsonObjectNode;
import com.jn.easyjson.core.node.JsonPrimitiveNode;
import com.jn.easyjson.core.node.JsonTreeNodes;
import com.jn.easyjson.core.node.ToJsonTreeNodeMapper;
import com.jn.easyjson.core.node.ToXxxJsonMapper;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class JacksonJsonMapper {
    public static JsonTreeNode toJsonTreeNode(Object obj) {
        return JsonTreeNodes.toJsonTreeNode((Object)obj, (ToJsonTreeNodeMapper)new JacksonToTreeNodeMapper());
    }

    public static JsonNode fromJsonTreeNode(JsonTreeNode treeNode) {
        return (JsonNode)JsonTreeNodes.toXxxJson((JsonTreeNode)treeNode, (ToXxxJsonMapper)new JacksonToJsonMapper());
    }

    static class JacksonToTreeNodeMapper
    implements ToJsonTreeNodeMapper {
        JacksonToTreeNodeMapper() {
        }

        public JsonTreeNode mapping(Object object) {
            return this.create((JsonNode)object);
        }

        public boolean isAcceptable(Object object) {
            return object instanceof JsonNode;
        }

        private JsonTreeNode createFromPojo(Object object) {
            if (object == null) {
                return JsonNullNode.INSTANCE;
            }
            if (object instanceof JsonNode) {
                return this.create((JsonNode)object);
            }
            if (object instanceof Number) {
                return new JsonPrimitiveNode((Number)object);
            }
            if (object instanceof String) {
                return new JsonPrimitiveNode(object.toString());
            }
            if (object instanceof Boolean) {
                return new JsonPrimitiveNode((Boolean)object);
            }
            if (object instanceof Collection) {
                Collection c = (Collection)object;
                JsonArrayNode arrayNode = new JsonArrayNode(c.size());
                for (Object e : c) {
                    arrayNode.add(this.createFromPojo(e));
                }
                return arrayNode;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                final JsonObjectNode jsonObjectNode = new JsonObjectNode();
                Collects.forEach((Map)map, (Consumer2)new Consumer2<Object, Object>(){

                    public void accept(Object key, Object value) {
                        jsonObjectNode.addProperty(key.toString(), JacksonToTreeNodeMapper.this.createFromPojo(value));
                    }
                });
                return jsonObjectNode;
            }
            return new JsonPrimitiveNode(object.toString());
        }

        private JsonTreeNode create(JsonNode jsonNode) {
            if (jsonNode.isNull()) {
                return JsonNullNode.INSTANCE;
            }
            if (jsonNode.isNumber()) {
                if (jsonNode.isShort() || jsonNode.isInt()) {
                    return new JsonPrimitiveNode((Number)jsonNode.intValue());
                }
                if (jsonNode.isFloat() || jsonNode.isFloatingPointNumber()) {
                    return new JsonPrimitiveNode((Number)Float.valueOf(jsonNode.floatValue()));
                }
                if (jsonNode.isDouble()) {
                    return new JsonPrimitiveNode((Number)jsonNode.doubleValue());
                }
                if (jsonNode.isLong()) {
                    return new JsonPrimitiveNode((Number)jsonNode.longValue());
                }
                if (jsonNode.isBigDecimal()) {
                    return new JsonPrimitiveNode((Number)jsonNode.decimalValue());
                }
                if (jsonNode.isBigInteger()) {
                    return new JsonPrimitiveNode((Number)jsonNode.bigIntegerValue());
                }
            }
            if (jsonNode.isBinary() || jsonNode.isTextual()) {
                return new JsonPrimitiveNode(jsonNode.textValue());
            }
            if (jsonNode.isBoolean()) {
                return new JsonPrimitiveNode(Boolean.valueOf(jsonNode.booleanValue()));
            }
            if (jsonNode.isArray()) {
                JsonArrayNode arrayNode = new JsonArrayNode(jsonNode.size());
                for (JsonNode element : jsonNode) {
                    arrayNode.add(this.create(element));
                }
                return arrayNode;
            }
            if (jsonNode.isObject()) {
                JsonObjectNode jsonObjectNode = new JsonObjectNode();
                Iterator iter = jsonNode.fieldNames();
                while (iter.hasNext()) {
                    String fieldName = (String)iter.next();
                    jsonObjectNode.addProperty(fieldName, this.create(jsonNode.get(fieldName)));
                }
                return jsonObjectNode;
            }
            if (jsonNode.isPojo()) {
                POJONode pojoNode = (POJONode)jsonNode;
                Object object = pojoNode.getPojo();
                return this.createFromPojo(object);
            }
            return JsonNullNode.INSTANCE;
        }
    }

    static class JacksonToJsonMapper
    implements ToXxxJsonMapper<ObjectNode, ArrayNode, ValueNode, NullNode> {
        JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(true);

        JacksonToJsonMapper() {
        }

        public NullNode mappingNull(JsonNullNode node) {
            return NullNode.instance;
        }

        public ValueNode mappingPrimitive(JsonPrimitiveNode node) {
            JsonPrimitiveNode jsonPrimitiveNode = node.getAsJsonPrimitiveNode();
            if (jsonPrimitiveNode.isNumber()) {
                if (jsonPrimitiveNode.isDouble()) {
                    return this.jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsDouble());
                }
                if (jsonPrimitiveNode.isLong()) {
                    return this.jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsLong());
                }
                if (jsonPrimitiveNode.isFloat()) {
                    return this.jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsFloat());
                }
                if (jsonPrimitiveNode.isInteger()) {
                    return this.jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsInt());
                }
                if (jsonPrimitiveNode.isShort()) {
                    return this.jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsShort());
                }
                if (jsonPrimitiveNode.isByte()) {
                    return this.jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsByte());
                }
                if (jsonPrimitiveNode.isBigInteger()) {
                    return this.jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsBigInteger());
                }
                if (jsonPrimitiveNode.isBigDecimal()) {
                    return this.jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsBigDecimal());
                }
            }
            if (jsonPrimitiveNode.isBoolean()) {
                return this.jsonNodeFactory.booleanNode(jsonPrimitiveNode.getAsBoolean());
            }
            if (jsonPrimitiveNode.isChar()) {
                return this.jsonNodeFactory.textNode(jsonPrimitiveNode.getAsString());
            }
            return this.jsonNodeFactory.textNode(jsonPrimitiveNode.getAsString());
        }

        public ArrayNode mappingArray(JsonArrayNode node) {
            JsonArrayNode jsonArrayNode = node.getAsJsonArrayNode();
            ArrayNode arrayNode = this.jsonNodeFactory.arrayNode();
            for (JsonTreeNode element : jsonArrayNode) {
                arrayNode.add((JsonNode)JsonTreeNodes.toXxxJson((JsonTreeNode)element, (ToXxxJsonMapper)this));
            }
            return arrayNode;
        }

        public ObjectNode mappingObject(JsonObjectNode node) {
            JsonObjectNode jsonObjectNode = node.getAsJsonObjectNode();
            ObjectNode objectNode = this.jsonNodeFactory.objectNode();
            for (String fieldName : jsonObjectNode.propertyNames()) {
                objectNode.set(fieldName, (JsonNode)JsonTreeNodes.toXxxJson((JsonTreeNode)jsonObjectNode.getProperty(fieldName), (ToXxxJsonMapper)this));
            }
            return objectNode;
        }
    }
}

