/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.jn.easyjson.core.codec.dialect.DialectIdentify;
import com.jn.easyjson.core.codec.dialect.PropertyCodecConfiguration;
import com.jn.easyjson.jackson.JacksonJSONBuilder;
import com.jn.easyjson.jackson.ext.EasyJsonObjectMapper;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Objs;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Reflects;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.TimeZone;

public class Jacksons {
    private static final Version CURRENT_VERSION;
    private static final String JACKSON_CORE_PACKAGE_NAME = "com.fasterxml.jackson.core";
    public static final DialectIdentify JACKSON;
    public static final Version VERSION_2_6_0;
    public static final Version VERSION_2_9_0;
    public static final Version VERSION_2_10_0;

    public static boolean isJacksonJavaType(Type type) {
        return type instanceof JavaType;
    }

    public static JavaType toJavaType(Type type) {
        return (JavaType)type;
    }

    public static boolean getBooleanAttr(DeserializationContext ctx, String key) {
        if (ctx == null || key == null) {
            return false;
        }
        return Jacksons.getBoolean(ctx.getAttribute((Object)key));
    }

    public static boolean getBooleanAttr(SerializerProvider sp, String key) {
        if (sp == null || key == null) {
            return false;
        }
        return Jacksons.getBoolean(sp.getAttribute((Object)key));
    }

    public static boolean getBoolean(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.toString().toLowerCase().equals("true");
    }

    public static TimeZone getTimeZone(DeserializationContext ctx) {
        return (TimeZone)Objs.useValueIfNull((Object)((TimeZone)ctx.getAttribute((Object)"SERIALIZE_TIMEZONE")), (Object)TimeZone.getDefault());
    }

    public static Locale getLocale(DeserializationContext ctx) {
        return (Locale)Objs.useValueIfNull((Object)((Locale)ctx.getAttribute((Object)"SERIALIZE_LOCALE")), (Object)Locale.getDefault());
    }

    public static DateFormat getDateFormatAttr(DeserializationContext ctx, String key) {
        if (ctx == null || key == null) {
            return null;
        }
        return Jacksons.asDateFormat(ctx.getAttribute((Object)key));
    }

    public static DateFormat getDateFormatAttr(SerializerProvider sp, String key) {
        if (sp == null || key == null) {
            return null;
        }
        return Jacksons.asDateFormat(sp.getAttribute((Object)key));
    }

    private static DateFormat asDateFormat(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DateFormat) {
            return (DateFormat)object;
        }
        return null;
    }

    public static String getStringAttr(DeserializationContext ctx, String key) {
        if (ctx == null || key == null) {
            return null;
        }
        return Jacksons.asString(ctx.getAttribute((Object)key));
    }

    public static String getStringAttr(SerializerProvider sp, String key) {
        if (sp == null || key == null) {
            return null;
        }
        return Jacksons.asString(sp.getAttribute((Object)key));
    }

    private static String asString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static PropertyCodecConfiguration getPropertyCodecConfiguration(JsonGenerator gen) {
        ObjectCodec objectCodec = gen.getCodec();
        if (!(objectCodec instanceof EasyJsonObjectMapper)) {
            return null;
        }
        JsonStreamContext streamContext = gen.getOutputContext();
        if (streamContext instanceof JsonWriteContext) {
            JsonWriteContext writeContext = (JsonWriteContext)streamContext;
            Object container = writeContext.getCurrentValue();
            String propertyName = writeContext.getCurrentName();
            EasyJsonObjectMapper objectMapper = (EasyJsonObjectMapper)objectCodec;
            JacksonJSONBuilder jsonBuilder = objectMapper.getJsonBuilder();
            DialectIdentify proxyDialectIdentify = jsonBuilder.proxyDialectIdentify();
            return PropertyCodecConfiguration.getPropertyCodecConfiguration((DialectIdentify)proxyDialectIdentify, (Object)container, (String)propertyName);
        }
        return null;
    }

    public static PropertyCodecConfiguration getPropertyCodecConfiguration(@NonNull JsonParser p) {
        ObjectCodec objectCodec = p.getCodec();
        if (!(objectCodec instanceof EasyJsonObjectMapper)) {
            return null;
        }
        JsonStreamContext parsingContext = p.getParsingContext();
        if (parsingContext instanceof JsonReadContext) {
            JsonReadContext readContext = (JsonReadContext)parsingContext;
            Object container = readContext.getCurrentValue();
            String propertyName = readContext.getCurrentName();
            EasyJsonObjectMapper objectMapper = (EasyJsonObjectMapper)objectCodec;
            JacksonJSONBuilder jsonBuilder = objectMapper.getJsonBuilder();
            DialectIdentify proxyDialectIdentify = jsonBuilder.proxyDialectIdentify();
            return PropertyCodecConfiguration.getPropertyCodecConfiguration((DialectIdentify)proxyDialectIdentify, (Object)container, (String)propertyName);
        }
        return null;
    }

    private static Version guessCurrentVersion() {
        JsonFactory factory = (JsonFactory)Pipeline.of(ServiceLoader.load(JsonFactory.class)).filter((Predicate)new Predicate<JsonFactory>(){

            public boolean test(JsonFactory jsonFactory) {
                return Jacksons.JACKSON_CORE_PACKAGE_NAME.equals(Reflects.getPackageName(jsonFactory.getClass()));
            }
        }).findFirst();
        Version template = factory.version();
        Version version = new Version(template.getMajorVersion(), template.getMinorVersion(), template.getPatchLevel(), null, null, null);
        return version;
    }

    public static Version getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public static void checkAndFixAccess(Member member, boolean force) {
        block3: {
            AccessibleObject ao = (AccessibleObject)((Object)member);
            try {
                if (force || !Modifier.isPublic(member.getModifiers()) || !Modifier.isPublic(member.getDeclaringClass().getModifiers())) {
                    ao.setAccessible(true);
                }
            }
            catch (SecurityException var5) {
                if (ao.isAccessible()) break block3;
                Class<?> declClass = member.getDeclaringClass();
                throw new IllegalArgumentException("Cannot access " + member + " (from class " + declClass.getName() + "; failed to set access: " + var5.getMessage());
            }
        }
    }

    static {
        JACKSON = new DialectIdentify();
        JACKSON.setId("jackson");
        JACKSON.setLibUrl(Reflects.getCodeLocation(ObjectMapper.class).toString());
        CURRENT_VERSION = Jacksons.guessCurrentVersion();
        VERSION_2_6_0 = new Version(2, 6, 0, null);
        VERSION_2_9_0 = new Version(2, 9, 0, null);
        VERSION_2_10_0 = new Version(2, 10, 0, null);
    }
}

