/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.utils;

import com.jn.langx.util.Strings;
import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.io.file.Files;
import com.jn.langx.util.logging.Loggers;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;

public class SshConfigs {
    private static final Logger logger = Loggers.getLogger(SshConfigs.class);

    public static List<File> getKnownHostsFiles(String paths) {
        return SshConfigs.getKnownHostsFiles(paths, true, true);
    }

    public static List<File> getKnownHostsFiles(String paths, boolean filterNotExist) {
        return SshConfigs.getKnownHostsFiles(paths, filterNotExist, true);
    }

    private static String replaceUserHome(String path) {
        String ret = path.replace("${user.home}", SystemPropertys.getUserHome().replace("\\", "/"));
        return ret;
    }

    public static List<File> getKnownHostsFiles(String paths, final boolean filterNotExist, final boolean mkIfDefaultNotExist) {
        final List files = Collects.emptyArrayList();
        if (Strings.isNotBlank((String)paths)) {
            Object[] paths2 = Strings.split((String)paths, (String)";");
            Collects.forEach((Object[])paths2, (Consumer)new Consumer<String>(){

                public void accept(String path) {
                    File file;
                    if (Strings.startsWith((CharSequence)path, (CharSequence)"~")) {
                        path = "${user.home}" + Strings.substring((String)path, (int)1);
                    }
                    if ((file = new File(path = SshConfigs.replaceUserHome(path))).exists()) {
                        files.add(file);
                    } else {
                        boolean isDefaultPath;
                        boolean makeAndAdd = false;
                        makeAndAdd = filterNotExist && mkIfDefaultNotExist ? (isDefaultPath = path.equals(SshConfigs.replaceUserHome("${user.home}/.ssh/known_hosts"))) : true;
                        if (makeAndAdd) {
                            try {
                                Files.makeFile((File)file);
                            }
                            catch (IOException ex) {
                                logger.warn(ex.getMessage(), (Throwable)ex);
                            }
                            if (file.exists()) {
                                files.add(file);
                            }
                        }
                    }
                }
            });
        }
        return files;
    }
}

