/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.utils;

import com.jn.agileway.ssh.client.SshException;
import com.jn.langx.util.io.Charsets;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;

public class Buffer<T extends Buffer<T>> {
    public static final int DEFAULT_SIZE = 256;
    public static final int MAX_SIZE = 0x40000000;
    protected byte[] data;
    protected int rpos;
    protected int wpos;

    protected static int getNextPowerOf2(int i) {
        int j = 1;
        while (j < i) {
            if ((j <<= 1) > 0) continue;
            throw new IllegalArgumentException("Cannot get next power of 2; " + i + " is too large");
        }
        return j;
    }

    public Buffer() {
        this(256);
    }

    public Buffer(Buffer<?> from) {
        this.wpos = from.wpos - from.rpos;
        this.data = new byte[this.wpos];
        System.arraycopy(from.data, from.rpos, this.data, 0, this.wpos);
    }

    public Buffer(byte[] data) {
        this(data, true);
    }

    public Buffer(int size) {
        this(new byte[Buffer.getNextPowerOf2(size)], false);
    }

    private Buffer(byte[] data, boolean read) {
        this.data = data;
        this.rpos = 0;
        this.wpos = read ? data.length : 0;
    }

    public byte[] array() {
        return this.data;
    }

    public int available() {
        return this.wpos - this.rpos;
    }

    public void clear() {
        this.rpos = 0;
        this.wpos = 0;
    }

    public int rpos() {
        return this.rpos;
    }

    public void rpos(int rpos) {
        this.rpos = rpos;
    }

    public int wpos() {
        return this.wpos;
    }

    public void wpos(int wpos) {
        this.ensureCapacity(wpos - this.wpos);
        this.wpos = wpos;
    }

    protected void ensureAvailable(int a) {
        if (this.available() < a) {
            throw new BufferException("Underflow");
        }
    }

    public void ensureCapacity(int capacity) {
        if (this.data.length - this.wpos < capacity) {
            int cw = this.wpos + capacity;
            byte[] tmp = new byte[Buffer.getNextPowerOf2(cw)];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
    }

    public byte[] getCompactData() {
        int len = this.available();
        if (len > 0) {
            byte[] b = new byte[len];
            System.arraycopy(this.data, this.rpos, b, 0, len);
            return b;
        }
        return new byte[0];
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public T putBoolean(boolean b) {
        return this.putByte(b ? (byte)1 : 0);
    }

    public byte readByte() {
        this.ensureAvailable(1);
        return this.data[this.rpos++];
    }

    public T putByte(byte b) {
        this.ensureCapacity(1);
        this.data[this.wpos++] = b;
        return (T)this;
    }

    public byte[] readBytes() {
        int len = this.readUInt32AsInt();
        if (len < 0 || len > 32768) {
            throw new BufferException("Bad item length: " + len);
        }
        byte[] b = new byte[len];
        this.readRawBytes(b);
        return b;
    }

    public T putBytes(byte[] b) {
        return this.putBytes(b, 0, b.length);
    }

    public T putBytes(byte[] b, int off, int len) {
        return ((Buffer)this.putUInt32(len - off)).putRawBytes(b, off, len);
    }

    public byte[] remainingRawBytes() {
        if (this.available() > 0) {
            byte[] bytes = new byte[this.available()];
            this.readRawBytes(bytes);
            return bytes;
        }
        return new byte[0];
    }

    public void readRawBytes(byte[] buf) {
        this.readRawBytes(buf, 0, buf.length);
    }

    public void readRawBytes(byte[] buf, int off, int len) {
        this.ensureAvailable(len);
        System.arraycopy(this.data, this.rpos, buf, off, len);
        this.rpos += len;
    }

    public T putRawBytes(byte[] d) {
        return this.putRawBytes(d, 0, d.length);
    }

    public T putRawBytes(byte[] d, int off, int len) {
        this.ensureCapacity(len);
        System.arraycopy(d, off, this.data, this.wpos, len);
        this.wpos += len;
        return (T)this;
    }

    public T putBuffer(Buffer<? extends Buffer<?>> buffer) {
        if (buffer != null) {
            int r = buffer.available();
            this.ensureCapacity(r);
            System.arraycopy(buffer.data, buffer.rpos, this.data, this.wpos, r);
            this.wpos += r;
        }
        return (T)this;
    }

    public int readUInt32AsInt() {
        return (int)this.readUInt32();
    }

    public long readUInt32() {
        this.ensureAvailable(4);
        return (long)(this.data[this.rpos++] << 24) & 0xFF000000L | (long)(this.data[this.rpos++] << 16) & 0xFF0000L | (long)(this.data[this.rpos++] << 8) & 0xFF00L | (long)this.data[this.rpos++] & 0xFFL;
    }

    public T putUInt32(long uint32) {
        this.ensureCapacity(4);
        if (uint32 < 0L || uint32 > 0xFFFFFFFFL) {
            throw new RuntimeException("Invalid value: " + uint32);
        }
        this.data[this.wpos++] = (byte)(uint32 >> 24);
        this.data[this.wpos++] = (byte)(uint32 >> 16);
        this.data[this.wpos++] = (byte)(uint32 >> 8);
        this.data[this.wpos++] = (byte)uint32;
        return (T)this;
    }

    public BigInteger readMPInt() {
        return new BigInteger(this.readBytes());
    }

    public T putMPInt(BigInteger bi) {
        byte[] asBytes = bi.toByteArray();
        this.putUInt32(asBytes.length);
        return this.putRawBytes(asBytes);
    }

    public long readUInt64() throws BufferException {
        long uint64 = (this.readUInt32() << 32) + (this.readUInt32() & 0xFFFFFFFFL);
        if (uint64 < 0L) {
            throw new BufferException("Cannot handle values > Long.MAX_VALUE");
        }
        return uint64;
    }

    public T putUInt64(long uint64) {
        if (uint64 < 0L) {
            throw new RuntimeException("Invalid value: " + uint64);
        }
        this.data[this.wpos++] = (byte)(uint64 >> 56);
        this.data[this.wpos++] = (byte)(uint64 >> 48);
        this.data[this.wpos++] = (byte)(uint64 >> 40);
        this.data[this.wpos++] = (byte)(uint64 >> 32);
        this.data[this.wpos++] = (byte)(uint64 >> 24);
        this.data[this.wpos++] = (byte)(uint64 >> 16);
        this.data[this.wpos++] = (byte)(uint64 >> 8);
        this.data[this.wpos++] = (byte)uint64;
        return (T)this;
    }

    public String readString() {
        int len = this.readUInt32AsInt();
        if (len < 0 || len > 32768) {
            throw new BufferException("Bad item length: " + len);
        }
        this.ensureAvailable(len);
        String s = new String(this.data, this.rpos, len, Charsets.UTF_8);
        this.rpos += len;
        return s;
    }

    public byte[] readStringAsBytes() {
        return this.readBytes();
    }

    public T putString(byte[] str) {
        return this.putBytes(str);
    }

    public T putString(byte[] str, int offset, int len) {
        return this.putBytes(str, offset, len);
    }

    public T putString(String string) {
        return this.putString(string.getBytes(Charsets.UTF_8));
    }

    public T putSensitiveString(char[] str) {
        if (str == null) {
            return this.putString("");
        }
        this.putUInt32(str.length);
        this.ensureCapacity(str.length);
        for (char c : str) {
            this.data[this.wpos++] = (byte)c;
        }
        Arrays.fill(str, ' ');
        return (T)this;
    }

    public T putSignature(String sigFormat, byte[] sigData) throws UnsupportedEncodingException {
        byte[] sig = ((PlainBuffer)((PlainBuffer)new PlainBuffer().putString(sigFormat)).putBytes(sigData)).getCompactData();
        return this.putString(sig);
    }

    public String toString() {
        return "Buffer [rpos=" + this.rpos + ", wpos=" + this.wpos + ", size=" + this.data.length + "]";
    }

    public static final class PlainBuffer
    extends Buffer<PlainBuffer> {
        public PlainBuffer() {
        }

        public PlainBuffer(Buffer<?> from) {
            super(from);
        }

        public PlainBuffer(byte[] b) {
            super(b);
        }

        public PlainBuffer(int size) {
            super(size);
        }
    }

    public static class BufferException
    extends SshException {
        public BufferException(String message) {
            super(message);
        }

        public BufferException(Exception ex) {
            super(ex);
        }
    }
}

