/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.transport.hostkey.knownhosts;

import com.jn.agileway.ssh.client.transport.hostkey.HostsKeyRepository;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.HashedHostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.HostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.KnownHostsFiles;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.SimpleHostsKeyEntry;
import com.jn.langx.lifecycle.AbstractInitializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.logging.Loggers;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class OpenSSHKnownHosts
extends AbstractInitializable
implements HostsKeyRepository {
    private static final Logger logger = Loggers.getLogger(OpenSSHKnownHosts.class);
    protected final File khFile;
    protected final Set<HostsKeyEntry> entries = new LinkedHashSet<HostsKeyEntry>();
    private String id;

    public OpenSSHKnownHosts(File khFile) {
        this.khFile = khFile;
        this.init();
        this.id = khFile.getAbsolutePath();
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected void doInit() throws InitializationException {
        if (this.khFile.exists()) {
            List<HostsKeyEntry> entries = null;
            try {
                entries = this.load();
                this.entries.addAll(entries);
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected List<HostsKeyEntry> load() throws IOException {
        List<HostsKeyEntry> entries = KnownHostsFiles.read(this.khFile);
        return entries;
    }

    public void rewrite() {
        try {
            KnownHostsFiles.rewrite(this.khFile, this.entries);
        }
        catch (IOException ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(HostsKeyEntry entry) {
        if (entry != null) {
            OpenSSHKnownHosts openSSHKnownHosts = this;
            synchronized (openSSHKnownHosts) {
                if (this.entries.add(entry)) {
                    this.rewrite();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(final String host, String type) {
        List<HostsKeyEntry> found = this.find(host, type);
        if (Objs.isNotEmpty(found)) {
            OpenSSHKnownHosts openSSHKnownHosts = this;
            synchronized (openSSHKnownHosts) {
                Pipeline.of(found).forEach((Consumer)new Consumer<HostsKeyEntry>(){

                    public void accept(HostsKeyEntry entry) {
                        if (entry instanceof SimpleHostsKeyEntry) {
                            SimpleHostsKeyEntry hostsKeyEntry = (SimpleHostsKeyEntry)entry;
                            String hostsString = hostsKeyEntry.getHosts();
                            List hosts = Collects.asList((Object[])Strings.split((String)hostsString, (String)","));
                            hosts.remove(host);
                            if (hosts.isEmpty()) {
                                OpenSSHKnownHosts.this.entries.remove(entry);
                            }
                        } else if (entry instanceof HashedHostsKeyEntry) {
                            OpenSSHKnownHosts.this.entries.remove(entry);
                        }
                    }
                });
                this.rewrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(HostsKeyEntry entry) {
        OpenSSHKnownHosts openSSHKnownHosts = this;
        synchronized (openSSHKnownHosts) {
            if (this.entries.remove(entry)) {
                this.rewrite();
            }
        }
    }

    @Override
    public List<HostsKeyEntry> getAll() {
        return Pipeline.of(this.entries).asList();
    }

    @Override
    public List<HostsKeyEntry> find(final String host, final String keyType) {
        Preconditions.checkNotNull((Object)host);
        return Pipeline.of(this.entries).filter((Predicate)new Predicate<HostsKeyEntry>(){

            public boolean test(HostsKeyEntry entry) {
                return entry.applicableTo(host, keyType);
            }
        }).asList();
    }
}

