/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.transport.hostkey.knownhosts;

import com.jn.agileway.ssh.client.SshException;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.AbstractHostsKeyEntry;
import com.jn.agileway.ssh.client.transport.hostkey.knownhosts.Marker;
import com.jn.langx.codec.base64.Base64;
import com.jn.langx.security.Securitys;
import com.jn.langx.security.crypto.mac.HMacs;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;

public class HashedHostsKeyEntry
extends AbstractHostsKeyEntry {
    public static final String HOSTS_FLAG = "|1|";
    private transient byte[] salt;
    private transient String hostsHash;

    public HashedHostsKeyEntry() {
    }

    public HashedHostsKeyEntry(String hosts, String keyType, Object publicKey) {
        this(null, hosts, keyType, publicKey);
    }

    public HashedHostsKeyEntry(Marker marker, String hosts, String keyType, Object publicKey) {
        super(marker, null, keyType, publicKey);
        if (hosts.startsWith(HOSTS_FLAG)) {
            String[] hostParts = Strings.split((String)hosts, (String)"\\|");
            if (hostParts.length != 3) {
                throw new SshException("Unrecognized format for hashed hostname");
            }
            this.salt = Base64.decodeBase64((String)hostParts[1]);
            this.hostsHash = hostParts[2];
            this.setHosts(this.getFormattedHosts());
        } else {
            this.setHosts(this.hash(hosts));
        }
    }

    private String getFormattedHosts() {
        return StringTemplates.formatWithPlaceholder((String)"|1|{}|{}", (Object[])new Object[]{Base64.encodeBase64String((byte[])this.salt), this.hostsHash});
    }

    private byte[] hash(byte[] hosts) {
        if (this.salt == null) {
            this.salt = HashedHostsKeyEntry.newSalt();
        }
        return HMacs.hmac((String)"HMacSHA1", (byte[])this.salt, (byte[])hosts);
    }

    private String hash(String hosts) {
        return Base64.encodeBase64String((byte[])this.hash(hosts.getBytes()));
    }

    private static byte[] newSalt() {
        byte[] salt = new byte[20];
        Securitys.getSecureRandom().nextBytes(salt);
        return salt;
    }

    @Override
    protected boolean containsHost(String host) {
        return Objs.equals((Object)this.hash(host), (Object)this.hostsHash);
    }
}

