/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.transport.hostkey.codec;

import com.jn.agileway.ssh.client.transport.hostkey.codec.AbstractPublicKeyCodec;
import com.jn.agileway.ssh.client.utils.Buffer;
import com.jn.langx.codec.CodecException;
import com.jn.langx.security.crypto.IllegalKeyException;
import com.jn.langx.security.crypto.key.PKIs;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;

public class SshRsaPublicKeyCodec
extends AbstractPublicKeyCodec {
    public SshRsaPublicKeyCodec() {
        this.setName("ssh-rsa");
    }

    @Override
    public PublicKey decode(byte[] bytes) throws CodecException {
        Buffer.PlainBuffer buf = new Buffer.PlainBuffer(bytes);
        try {
            BigInteger e = buf.readMPInt();
            BigInteger n = buf.readMPInt();
            return PKIs.getKeyFactory((String)"RSA", null).generatePublic(new RSAPublicKeySpec(n, e));
        }
        catch (Buffer.BufferException be) {
            throw new IllegalKeyException((Throwable)be);
        }
        catch (InvalidKeySpecException ex) {
            throw new IllegalKeyException((Throwable)ex);
        }
    }

    @Override
    public byte[] encode(PublicKey publicKey) throws CodecException {
        Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
        RSAPublicKey rsaKey = (RSAPublicKey)publicKey;
        ((Buffer)((Buffer)buf.putString(this.getName())).putMPInt(rsaKey.getPublicExponent())).putMPInt(rsaKey.getModulus());
        return buf.array();
    }

    @Override
    protected boolean isPublicKeyMatched(PublicKey publicKey, String algorithm) {
        return "RSA".equals(algorithm);
    }
}

