/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.transport.hostkey.codec;

import com.jn.agileway.ssh.client.transport.hostkey.codec.AbstractPublicKeyCodec;
import com.jn.agileway.ssh.client.utils.Buffer;
import com.jn.langx.codec.CodecException;
import com.jn.langx.security.crypto.IllegalKeyException;
import com.jn.langx.security.crypto.key.PKIs;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;

public class SshDssPublicKeyCodec
extends AbstractPublicKeyCodec {
    public SshDssPublicKeyCodec() {
        this.setName("ssh-dss");
    }

    @Override
    public PublicKey decode(byte[] bytes) throws CodecException {
        BigInteger y;
        BigInteger g;
        BigInteger q;
        BigInteger p;
        Buffer.PlainBuffer buf = new Buffer.PlainBuffer(bytes);
        try {
            p = buf.readMPInt();
            q = buf.readMPInt();
            g = buf.readMPInt();
            y = buf.readMPInt();
        }
        catch (Buffer.BufferException be) {
            throw new IllegalKeyException((Throwable)be);
        }
        try {
            return PKIs.getKeyFactory((String)"DSA", null).generatePublic(new DSAPublicKeySpec(y, p, q, g));
        }
        catch (InvalidKeySpecException ex) {
            throw new IllegalKeyException();
        }
    }

    @Override
    public byte[] encode(PublicKey publicKey) throws CodecException {
        Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
        DSAPublicKey dsaKey = (DSAPublicKey)publicKey;
        ((Buffer)((Buffer)((Buffer)((Buffer)buf.putString(this.getName())).putMPInt(dsaKey.getParams().getP())).putMPInt(dsaKey.getParams().getQ())).putMPInt(dsaKey.getParams().getG())).putMPInt(dsaKey.getY());
        return buf.array();
    }

    @Override
    protected boolean isPublicKeyMatched(PublicKey publicKey, String algorithm) {
        return "DSA".equals(algorithm);
    }
}

