/*
 * Decompiled with CFR 0.152.
 */
package com.jn.agileway.ssh.client.transport.hostkey.codec;

import com.jn.agileway.ssh.client.transport.hostkey.codec.PublicKeyCodec;
import com.jn.agileway.ssh.client.transport.hostkey.keytype.DefaultPublicKeyHostKeyTypeExtractor;
import com.jn.agileway.ssh.client.transport.hostkey.keytype.PublicKeyHostKeyTypeExtractor;
import com.jn.langx.annotation.Singleton;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.util.logging.Loggers;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class PublicKeyCodecRegistry
extends GenericRegistry<PublicKeyCodec> {
    private static PublicKeyCodecRegistry INSTANCE;

    private PublicKeyCodecRegistry() {
        super(new ConcurrentHashMap());
    }

    protected void doInit() throws InitializationException {
        Iterator<PublicKeyCodec> loader = ServiceLoader.load(PublicKeyCodec.class).iterator();
        while (loader.hasNext()) {
            try {
                PublicKeyCodec codec = loader.next();
                this.register(codec);
                if (!(codec instanceof PublicKeyHostKeyTypeExtractor)) continue;
                DefaultPublicKeyHostKeyTypeExtractor.getInstance().addPublicKeyHostKeyTypeExtractor(codec.getName(), codec);
            }
            catch (Throwable ex) {
                Loggers.getLogger(PublicKeyCodecRegistry.class).warn(ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PublicKeyCodecRegistry getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<PublicKeyCodecRegistry> clazz = PublicKeyCodecRegistry.class;
        synchronized (PublicKeyCodecRegistry.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new PublicKeyCodecRegistry();
            INSTANCE.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }
}

